/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field36C
extends Field
implements Serializable,
GenericField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "36C";
    public static final String F_36C = "36C";
    public static final String PARSER_PATTERN = ":S//S";
    public static final String COMPONENTS_PATTERN = "SS";
    public static final Integer QUALIFIER = 1;
    public static final Integer CODE = 2;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field36C() {
        super(2);
    }

    public Field36C(String value) {
        super(value);
    }

    public Field36C(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"36C")) {
            throw new IllegalArgumentException("cannot create field 36C from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "//"));
    }

    public static Field36C newInstance(Field36C source) {
        Field36C cp = new Field36C();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append("//");
        result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("36C", value);
    }

    public static Tag emptyTag() {
        return new Tag("36C", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field36C setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field36C setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getCode() {
        return this.getComponent(2);
    }

    public Field36C setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field36C setCode(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "36C";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//4!c";
    }

    public static Field36C get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("36C");
        if (t == null) {
            return null;
        }
        return new Field36C(t);
    }

    public static Field36C get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field36C.get(msg.getBlock4());
    }

    public static List<Field36C> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field36C.getAll(msg.getBlock4());
    }

    public static List<Field36C> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("36C");
        if (arr != null && arr.length > 0) {
            ArrayList<Field36C> result = new ArrayList<Field36C>(arr.length);
            for (Tag f : arr) {
                result.add(new Field36C(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 36C");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Code");
        return result;
    }
}

