/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field37B
extends Field
implements Serializable,
DateContainer,
AmountContainer {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "37B";
    public static final String F_37B = "37B";
    public static final String PARSER_PATTERN = "N[//<DATE2>cS][/S]";
    public static final String COMPONENTS_PATTERN = "NESNS";
    public static final Integer RATE = 1;
    public static final Integer DATE = 2;
    public static final Integer DM_MARK = 3;

    public Field37B() {
        super(5);
    }

    public Field37B(String value) {
        super(value);
    }

    public Field37B(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"37B")) {
            throw new IllegalArgumentException("cannot create field 37B from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(5);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "//"));
        String toparse = SwiftParseUtils.getTokenSecond(value, "//");
        if (toparse != null) {
            if (toparse.length() >= 6) {
                this.setComponent2(StringUtils.substring((String)toparse, (int)0, (int)6));
            }
            if (toparse.length() >= 7) {
                this.setComponent3(StringUtils.substring((String)toparse, (int)6, (int)7));
            }
            if (toparse.length() > 7) {
                String toparse2 = StringUtils.substring((String)toparse, (int)7);
                this.setComponent4(SwiftParseUtils.getTokenFirst(toparse2, "/"));
                this.setComponent5(SwiftParseUtils.getTokenSecondLast(toparse2, "/"));
            }
        }
    }

    public static Field37B newInstance(Field37B source) {
        Field37B cp = new Field37B();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        if (StringUtils.isNotEmpty((String)this.getComponent2()) || StringUtils.isNotEmpty((String)this.getComponent3()) || StringUtils.isNotEmpty((String)this.getComponent4())) {
            result.append("//");
            if (StringUtils.isNotEmpty((String)this.getComponent2())) {
                result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
            }
            if (StringUtils.isNotEmpty((String)this.getComponent3())) {
                result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
            }
            if (StringUtils.isNotEmpty((String)this.getComponent4())) {
                result.append(StringUtils.trimToEmpty((String)this.getComponent4()));
            }
        }
        if (StringUtils.isNotEmpty((String)this.getComponent5())) {
            result.append("/");
            result.append(StringUtils.trimToEmpty((String)this.getComponent5()));
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("37B", value);
    }

    public static Tag emptyTag() {
        return new Tag("37B", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Number getComponent1AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public String getRate() {
        return this.getComponent(1);
    }

    public Number getRateAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public Field37B setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field37B setComponent1(Number component1) {
        this.setComponent(1, SwiftFormatUtils.getNumber(component1));
        return this;
    }

    public Field37B setRate(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field37B setRate(Number component1) {
        this.setComponent1(component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent(2);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public Field37B setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field37B setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate2(component2));
        return this;
    }

    public Field37B setDate(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field37B setDate(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getDMMark() {
        return this.getComponent(3);
    }

    public Field37B setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field37B setDMMark(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field37B setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field37B setComponent4(Number component4) {
        this.setComponent(4, SwiftFormatUtils.getNumber(component4));
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public Field37B setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate2(this.getComponent(2)));
        return result;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        return component == 5;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "37B";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<AMOUNT>12[//<DATE2><DM>3n][/16x]";
    }

    public static Field37B get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("37B");
        if (t == null) {
            return null;
        }
        return new Field37B(t);
    }

    public static Field37B get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field37B.get(msg.getBlock4());
    }

    public static List<Field37B> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field37B.getAll(msg.getBlock4());
    }

    public static List<Field37B> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("37B");
        if (arr != null && arr.length > 0) {
            ArrayList<Field37B> result = new ArrayList<Field37B>(arr.length);
            for (Tag f : arr) {
                result.add(new Field37B(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        Format f;
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 37B");
        }
        if (component == 1) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent1AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Rate");
        result.add("Date");
        result.add("D/M Mark");
        result.add(null);
        result.add(null);
        return result;
    }
}

