/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field40B
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "40B";
    public static final String F_40B = "40B";
    public static final String PARSER_PATTERN = "S$S";
    public static final String COMPONENTS_PATTERN = "SS";

    public Field40B() {
        super(2);
    }

    public Field40B(String value) {
        super(value);
    }

    public Field40B(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"40B")) {
            throw new IllegalArgumentException("cannot create field 40B from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(2);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            this.setComponent1(lines.get(0));
            if (lines.size() > 1) {
                this.setComponent2(lines.get(1));
            }
        }
    }

    public static Field40B newInstance(Field40B source) {
        Field40B cp = new Field40B();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            result.append("\r\n");
            result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("40B", value);
    }

    public static Tag emptyTag() {
        return new Tag("40B", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public Field40B setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public Field40B setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "40B";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "24x$24x";
    }

    public static Field40B get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("40B");
        if (t == null) {
            return null;
        }
        return new Field40B(t);
    }

    public static Field40B get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field40B.get(msg.getBlock4());
    }

    public static List<Field40B> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field40B.getAll(msg.getBlock4());
    }

    public static List<Field40B> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("40B");
        if (arr != null && arr.length > 0) {
            ArrayList<Field40B> result = new ArrayList<Field40B>(arr.length);
            for (Tag f : arr) {
                result.add(new Field40B(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field40B cp = Field40B.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field40B cp = Field40B.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field40B cp = Field40B.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 40B");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(null);
        result.add(null);
        return result;
    }
}

