/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field50H
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "50H";
    public static final String F_50H = "50H";
    public static final String PARSER_PATTERN = "/S$S[$S]0-3";
    public static final String COMPONENTS_PATTERN = "SSSSS";
    public static final Integer ACCOUNT = 1;
    public static final Integer NAME_AND_ADDRESS = 2;

    public Field50H() {
        super(5);
    }

    public Field50H(String value) {
        super(value);
    }

    public Field50H(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"50H")) {
            throw new IllegalArgumentException("cannot create field 50H from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(5);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            this.setComponent1(SwiftParseUtils.getTokenFirst(lines.get(0), "/", null));
            if (lines.size() > 1) {
                this.setComponent2(lines.get(1));
            }
            if (lines.size() > 2) {
                this.setComponent3(lines.get(2));
            }
            if (lines.size() > 3) {
                this.setComponent4(lines.get(3));
            }
            if (lines.size() > 4) {
                this.setComponent5(lines.get(4));
            }
        }
    }

    public static Field50H newInstance(Field50H source) {
        Field50H cp = new Field50H();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append("\r\n");
        result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        this.appendInLines(result, 3, 5);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("50H", value);
    }

    public static Tag emptyTag() {
        return new Tag("50H", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getAccount() {
        String c = this.getComponent(1);
        if (c != null) {
            for (int i = 0; i < c.length(); ++i) {
                if (c.charAt(i) == '/') continue;
                return c.substring(i);
            }
            return "";
        }
        return null;
    }

    public Field50H setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field50H setAccount(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getNameAndAddressLine1() {
        return this.getComponent(2);
    }

    public String getNameAndAddressLine2() {
        return this.getComponent(3);
    }

    public String getNameAndAddressLine3() {
        return this.getComponent(4);
    }

    public String getNameAndAddressLine4() {
        return this.getComponent(5);
    }

    public String getNameAndAddress() {
        StringBuilder result = new StringBuilder();
        for (int i = 2; i < 6; ++i) {
            if (!StringUtils.isNotBlank((String)this.getComponent(i))) continue;
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent(i)));
        }
        return result.toString();
    }

    public Field50H setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field50H setNameAndAddressLine1(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field50H setNameAndAddressLine2(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field50H setNameAndAddressLine3(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field50H setNameAndAddressLine4(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field50H setNameAndAddress(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 2, 4, 0, lines);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public Field50H setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    @Deprecated
    public String getComponent4AsString() {
        return this.getComponent(4);
    }

    public Field50H setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public Field50H setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "50H";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "/34x$35x[$35x]0-3";
    }

    public static Field50H get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("50H");
        if (t == null) {
            return null;
        }
        return new Field50H(t);
    }

    public static Field50H get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field50H.get(msg.getBlock4());
    }

    public static List<Field50H> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field50H.getAll(msg.getBlock4());
    }

    public static List<Field50H> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("50H");
        if (arr != null && arr.length > 0) {
            ArrayList<Field50H> result = new ArrayList<Field50H>(arr.length);
            for (Tag f : arr) {
                result.add(new Field50H(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field50H cp = Field50H.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field50H cp = Field50H.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field50H cp = Field50H.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 50H");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Account");
        result.add("Name And Address");
        result.add("Name And Address 2");
        result.add("Name And Address 3");
        result.add("Name And Address 4");
        return result;
    }
}

