/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field52D
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "52D";
    public static final String F_52D = "52D";
    public static final String PARSER_PATTERN = "[[/c][/S]$]S[$S]0-3";
    public static final String COMPONENTS_PATTERN = "SSSSSS";
    public static final Integer DC_MARK = 1;
    public static final Integer ACCOUNT = 2;
    public static final Integer NAME_AND_ADDRESS = 3;

    public Field52D() {
        super(6);
    }

    public Field52D(String value) {
        super(value);
    }

    public Field52D(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"52D")) {
            throw new IllegalArgumentException("cannot create field 52D from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(6);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (lines.isEmpty()) {
            return;
        }
        if (lines.get(0).startsWith("/")) {
            if (lines.get(0).startsWith("//")) {
                this.setComponent1("");
                this.setComponent2(StringUtils.trimToNull((String)StringUtils.substring((String)lines.get(0), (int)2)));
            } else {
                String t1 = SwiftParseUtils.getTokenFirst(lines.get(0), "/", "/");
                if (StringUtils.isNotEmpty((String)t1)) {
                    if (t1.length() == 1) {
                        this.setComponent1(t1);
                        this.setComponent2(SwiftParseUtils.getTokenSecondLast(StringUtils.substring((String)lines.get(0), (int)1), "/"));
                    } else {
                        this.setComponent2(StringUtils.trimToNull((String)StringUtils.substring((String)lines.get(0), (int)1)));
                    }
                }
            }
            SwiftParseUtils.setComponentsFromLines(this, 3, null, 1, lines);
        } else {
            SwiftParseUtils.setComponentsFromLines(this, 3, null, 0, lines);
        }
    }

    public static Field52D newInstance(Field52D source) {
        Field52D cp = new Field52D();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        boolean wroteSomething = false;
        if (this.getComponent1() != null) {
            result.append("/" + StringUtils.trimToEmpty((String)this.getComponent1()));
            wroteSomething = true;
        }
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            result.append("/" + this.getComponent2());
            wroteSomething = true;
        }
        if (StringUtils.isNotEmpty((String)this.getComponent3())) {
            if (wroteSomething) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
            wroteSomething = true;
        }
        if (StringUtils.isNotEmpty((String)this.getComponent4())) {
            if (wroteSomething) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent4()));
            wroteSomething = true;
        }
        if (StringUtils.isNotEmpty((String)this.getComponent5())) {
            if (wroteSomething) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent5()));
            wroteSomething = true;
        }
        if (StringUtils.isNotEmpty((String)this.getComponent6())) {
            if (wroteSomething) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent6()));
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("52D", value);
    }

    public static Tag emptyTag() {
        return new Tag("52D", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public Field52D setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field52D setDCMark(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getAccount() {
        String c = this.getComponent(2);
        if (c != null) {
            for (int i = 0; i < c.length(); ++i) {
                if (c.charAt(i) == '/') continue;
                return c.substring(i);
            }
            return "";
        }
        return null;
    }

    public Field52D setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field52D setAccount(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getNameAndAddressLine1() {
        return this.getComponent(3);
    }

    public String getNameAndAddressLine2() {
        return this.getComponent(4);
    }

    public String getNameAndAddressLine3() {
        return this.getComponent(5);
    }

    public String getNameAndAddressLine4() {
        return this.getComponent(6);
    }

    public String getNameAndAddress() {
        StringBuilder result = new StringBuilder();
        for (int i = 3; i < 7; ++i) {
            if (!StringUtils.isNotBlank((String)this.getComponent(i))) continue;
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent(i)));
        }
        return result.toString();
    }

    public Field52D setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field52D setNameAndAddressLine1(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field52D setNameAndAddressLine2(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field52D setNameAndAddressLine3(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field52D setNameAndAddressLine4(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field52D setNameAndAddress(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 3, 4, 0, lines);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    @Deprecated
    public String getComponent4AsString() {
        return this.getComponent(4);
    }

    public Field52D setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public Field52D setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    @Deprecated
    public String getComponent6AsString() {
        return this.getComponent(6);
    }

    public Field52D setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 1) {
            return true;
        }
        if (component == 2) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        if (component == 5) {
            return true;
        }
        return component == 6;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "52D";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "[[/<DC>][/34x]$]35x[$35x]0-3";
    }

    public static Field52D get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("52D");
        if (t == null) {
            return null;
        }
        return new Field52D(t);
    }

    public static Field52D get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field52D.get(msg.getBlock4());
    }

    public static List<Field52D> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field52D.getAll(msg.getBlock4());
    }

    public static List<Field52D> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("52D");
        if (arr != null && arr.length > 0) {
            ArrayList<Field52D> result = new ArrayList<Field52D>(arr.length);
            for (Tag f : arr) {
                result.add(new Field52D(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field52D cp = Field52D.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field52D cp = Field52D.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field52D cp = Field52D.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 52D");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            return this.getComponent(6);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("D/C Mark");
        result.add("Account");
        result.add("Name And Address");
        result.add("Name And Address 2");
        result.add("Name And Address 3");
        result.add("Name And Address 4");
        return result;
    }
}

