/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field52G
extends Field
implements Serializable,
BICContainer,
MultiLineField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "52G";
    public static final String F_52G = "52G";
    public static final String PARSER_PATTERN = "/S$S";
    public static final String COMPONENTS_PATTERN = "SB";
    public static final Integer ACCOUNT = 1;
    public static final Integer BIC = 2;

    public Field52G() {
        super(2);
    }

    public Field52G(String value) {
        super(value);
    }

    public Field52G(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"52G")) {
            throw new IllegalArgumentException("cannot create field 52G from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(2);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            this.setComponent1(SwiftParseUtils.getTokenFirst(lines.get(0), "/", null));
            if (lines.size() > 1) {
                this.setComponent2(lines.get(1));
            }
        }
    }

    public static Field52G newInstance(Field52G source) {
        Field52G cp = new Field52G();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            result.append("\r\n");
            result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("52G", value);
    }

    public static Tag emptyTag() {
        return new Tag("52G", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getAccount() {
        String c = this.getComponent(1);
        if (c != null) {
            for (int i = 0; i < c.length(); ++i) {
                if (c.charAt(i) == '/') continue;
                return c.substring(i);
            }
            return "";
        }
        return null;
    }

    public Field52G setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field52G setAccount(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BIC getComponent2AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(2));
    }

    public String getBIC() {
        return this.getComponent(2);
    }

    public BIC getBICAsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(2));
    }

    public Field52G setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field52G setComponent2(BIC component2) {
        this.setComponent(2, SwiftFormatUtils.getBIC(component2));
        return this;
    }

    public Field52G setBIC(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field52G setBIC(BIC component2) {
        this.setComponent2(component2);
        return this;
    }

    @Override
    public List<BIC> bics() {
        ArrayList<BIC> result = new ArrayList<BIC>();
        result.add(SwiftFormatUtils.getBIC(this.getComponent(2)));
        return result;
    }

    @Override
    public List<String> bicStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getComponent(2));
        return result;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "52G";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "/34x$<BIC>";
    }

    public static Field52G get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("52G");
        if (t == null) {
            return null;
        }
        return new Field52G(t);
    }

    public static Field52G get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field52G.get(msg.getBlock4());
    }

    public static List<Field52G> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field52G.getAll(msg.getBlock4());
    }

    public static List<Field52G> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("52G");
        if (arr != null && arr.length > 0) {
            ArrayList<Field52G> result = new ArrayList<Field52G>(arr.length);
            for (Tag f : arr) {
                result.add(new Field52G(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field52G cp = Field52G.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field52G cp = Field52G.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field52G cp = Field52G.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 52G");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Account");
        result.add("BIC");
        return result;
    }
}

