/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field77H
extends Field
implements Serializable,
DateContainer,
MultiLineField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "77H";
    public static final String F_77H = "77H";
    public static final String PARSER_PATTERN = "S[/S][//S]";
    public static final String COMPONENTS_PATTERN = "SDY";
    public static final Integer TYPE_OF_AGREEMENT = 1;
    public static final Integer DATE = 2;
    public static final Integer VERSION = 3;

    public Field77H() {
        super(3);
    }

    public Field77H(String value) {
        super(value);
    }

    public Field77H(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"77H")) {
            throw new IllegalArgumentException("cannot create field 77H from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, null, "/"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "/");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "//"));
        this.setComponent3(SwiftParseUtils.getTokenSecondLast(toparse, "//"));
    }

    public static Field77H newInstance(Field77H source) {
        Field77H cp = new Field77H();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            result.append("/");
            result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        }
        if (StringUtils.isNotEmpty((String)this.getComponent3())) {
            result.append("//");
            result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("77H", value);
    }

    public static Tag emptyTag() {
        return new Tag("77H", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getTypeOfAgreement() {
        return this.getComponent(1);
    }

    public Field77H setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field77H setTypeOfAgreement(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent(2);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(2));
    }

    public Field77H setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field77H setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate4(component2));
        return this;
    }

    public Field77H setDate(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field77H setDate(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getYear(this.getComponent(3));
    }

    public String getVersion() {
        return this.getComponent(3);
    }

    public Calendar getVersionAsCalendar() {
        return SwiftFormatUtils.getYear(this.getComponent(3));
    }

    public Field77H setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field77H setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getYear(component3));
        return this;
    }

    public Field77H setVersion(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field77H setVersion(Calendar component3) {
        this.setComponent3(component3);
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate4(this.getComponent(2)));
        result.add(SwiftFormatUtils.getYear(this.getComponent(3)));
        return result;
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        return component == 3;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "77H";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "6a[/<DATE4>][//<YEAR>]";
    }

    public static Field77H get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("77H");
        if (t == null) {
            return null;
        }
        return new Field77H(t);
    }

    public static Field77H get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field77H.get(msg.getBlock4());
    }

    public static List<Field77H> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field77H.getAll(msg.getBlock4());
    }

    public static List<Field77H> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("77H");
        if (arr != null && arr.length > 0) {
            ArrayList<Field77H> result = new ArrayList<Field77H>(arr.length);
            for (Tag f : arr) {
                result.add(new Field77H(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field77H cp = Field77H.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field77H cp = Field77H.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field77H cp = Field77H.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 77H");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            DateFormat f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Type Of Agreement");
        result.add("Date");
        result.add("Version");
        return result;
    }
}

