/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field94G
extends Field
implements Serializable,
GenericField,
MultiLineField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "94G";
    public static final String F_94G = "94G";
    public static final String PARSER_PATTERN = ":S//S[$S]";
    public static final String COMPONENTS_PATTERN = "SSS";
    public static final Integer QUALIFIER = 1;
    public static final Integer ADDRESS = 2;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field94G() {
        super(3);
    }

    public Field94G(String value) {
        super(value);
    }

    public Field94G(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"94G")) {
            throw new IllegalArgumentException("cannot create field 94G from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(3);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            String line1 = lines.get(0);
            this.setComponent1(SwiftParseUtils.getTokenFirst(line1, ":", "//"));
            this.setComponent2(SwiftParseUtils.getTokenSecondLast(line1, "//"));
            if (lines.size() > 1) {
                this.setComponent3(lines.get(1));
            }
        }
    }

    public static Field94G newInstance(Field94G source) {
        Field94G cp = new Field94G();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append("//");
        result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        if (StringUtils.isNotEmpty((String)this.getComponent3())) {
            result.append("\r\n");
            result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("94G", value);
    }

    public static Tag emptyTag() {
        return new Tag("94G", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field94G setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field94G setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getAddressLine1() {
        return this.getComponent(2);
    }

    public String getAddressLine2() {
        return this.getComponent(3);
    }

    public String getAddress() {
        StringBuilder result = new StringBuilder();
        for (int i = 2; i < 4; ++i) {
            if (!StringUtils.isNotBlank((String)this.getComponent(i))) continue;
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent(i)));
        }
        return result.toString();
    }

    public Field94G setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field94G setAddressLine1(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field94G setAddressLine2(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field94G setAddress(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 2, 2, 0, lines);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public Field94G setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return component == 3;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "94G";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//35x[$35x]";
    }

    public static Field94G get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("94G");
        if (t == null) {
            return null;
        }
        return new Field94G(t);
    }

    public static Field94G get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field94G.get(msg.getBlock4());
    }

    public static List<Field94G> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field94G.getAll(msg.getBlock4());
    }

    public static List<Field94G> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("94G");
        if (arr != null && arr.length > 0) {
            ArrayList<Field94G> result = new ArrayList<Field94G>(arr.length);
            for (Tag f : arr) {
                result.add(new Field94G(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field94G cp = Field94G.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field94G cp = Field94G.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field94G cp = Field94G.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 94G");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Address");
        result.add("Address 2");
        return result;
    }
}

