/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field96A
extends Field
implements Serializable,
BICContainer,
MultiLineField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "96A";
    public static final String F_96A = "96A";
    public static final String PARSER_PATTERN = "[[/c][/S]$]S";
    public static final String COMPONENTS_PATTERN = "SSB";
    public static final Integer DC_MARK = 1;
    public static final Integer ACCOUNT = 2;
    public static final Integer BIC = 3;

    public Field96A() {
        super(3);
    }

    public Field96A(String value) {
        super(value);
    }

    public Field96A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"96A")) {
            throw new IllegalArgumentException("cannot create field 96A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(3);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (lines.isEmpty()) {
            return;
        }
        if (lines.get(0).startsWith("/")) {
            if (lines.get(0).startsWith("//")) {
                this.setComponent1("");
                this.setComponent2(StringUtils.trimToNull((String)StringUtils.substring((String)lines.get(0), (int)2)));
            } else {
                String t1 = SwiftParseUtils.getTokenFirst(lines.get(0), "/", "/");
                if (StringUtils.isNotEmpty((String)t1)) {
                    if (t1.length() == 1) {
                        this.setComponent1(t1);
                        this.setComponent2(SwiftParseUtils.getTokenSecondLast(StringUtils.substring((String)lines.get(0), (int)1), "/"));
                    } else {
                        this.setComponent2(StringUtils.trimToNull((String)StringUtils.substring((String)lines.get(0), (int)1)));
                    }
                }
            }
            if (lines.size() > 1) {
                this.setComponent3(lines.get(1));
            }
        } else {
            this.setComponent3(lines.get(0));
        }
    }

    public static Field96A newInstance(Field96A source) {
        Field96A cp = new Field96A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        boolean wroteSomething = false;
        if (this.getComponent1() != null) {
            result.append("/" + StringUtils.trimToEmpty((String)this.getComponent1()));
            wroteSomething = true;
        }
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            result.append("/" + StringUtils.trimToEmpty((String)this.getComponent2()));
            wroteSomething = true;
        }
        if (StringUtils.isNotEmpty((String)this.getComponent3())) {
            if (wroteSomething) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("96A", value);
    }

    public static Tag emptyTag() {
        return new Tag("96A", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public Field96A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field96A setDCMark(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getAccount() {
        String c = this.getComponent(2);
        if (c != null) {
            for (int i = 0; i < c.length(); ++i) {
                if (c.charAt(i) == '/') continue;
                return c.substring(i);
            }
            return "";
        }
        return null;
    }

    public Field96A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field96A setAccount(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public BIC getComponent3AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(3));
    }

    public String getBIC() {
        return this.getComponent(3);
    }

    public BIC getBICAsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(3));
    }

    public Field96A setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field96A setComponent3(BIC component3) {
        this.setComponent(3, SwiftFormatUtils.getBIC(component3));
        return this;
    }

    public Field96A setBIC(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field96A setBIC(BIC component3) {
        this.setComponent3(component3);
        return this;
    }

    @Override
    public List<BIC> bics() {
        ArrayList<BIC> result = new ArrayList<BIC>();
        result.add(SwiftFormatUtils.getBIC(this.getComponent(3)));
        return result;
    }

    @Override
    public List<String> bicStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getComponent(3));
        return result;
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 1) {
            return true;
        }
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "96A";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "[[/<DC>][/34x]$]<BIC>";
    }

    public static Field96A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("96A");
        if (t == null) {
            return null;
        }
        return new Field96A(t);
    }

    public static Field96A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field96A.get(msg.getBlock4());
    }

    public static List<Field96A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field96A.getAll(msg.getBlock4());
    }

    public static List<Field96A> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("96A");
        if (arr != null && arr.length > 0) {
            ArrayList<Field96A> result = new ArrayList<Field96A>(arr.length);
            for (Tag f : arr) {
                result.add(new Field96A(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field96A cp = Field96A.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field96A cp = Field96A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field96A cp = Field96A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 96A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("D/C Mark");
        result.add("Account");
        result.add("BIC");
        return result;
    }
}

