/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field98F
extends Field
implements Serializable,
GenericField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "98F";
    public static final String F_98F = "98F";
    public static final String PARSER_PATTERN = ":S/[S]/S<TIME2>";
    public static final String COMPONENTS_PATTERN = "SSST";
    public static final Integer QUALIFIER = 1;
    public static final Integer DATA_SOURCE_SCHEME = 2;
    public static final Integer CODE = 3;
    public static final Integer TIME = 4;
    public static final Integer CONDITIONAL_QUALIFIER = 3;

    public Field98F() {
        super(4);
    }

    public Field98F(String value) {
        super(value);
    }

    public Field98F(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"98F")) {
            throw new IllegalArgumentException("cannot create field 98F from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "/"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "/");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        String toparse2 = SwiftParseUtils.getTokenSecondLast(toparse, "/");
        if (toparse2 != null) {
            if (toparse2.length() >= 6) {
                this.setComponent3(StringUtils.substring((String)toparse2, (int)0, (int)(toparse2.length() - 6)));
                this.setComponent4(StringUtils.substring((String)toparse2, (int)(toparse2.length() - 6)));
            } else {
                this.setComponent3(toparse2);
            }
        }
    }

    public static Field98F newInstance(Field98F source) {
        Field98F cp = new Field98F();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append("/");
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        }
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("98F", value);
    }

    public static Tag emptyTag() {
        return new Tag("98F", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field98F setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field98F setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getDataSourceScheme() {
        return this.getComponent(2);
    }

    public Field98F setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field98F setDataSourceScheme(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getCode() {
        return this.getComponent(3);
    }

    public Field98F setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field98F setCode(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(4));
    }

    public String getTime() {
        return this.getComponent(4);
    }

    public Calendar getTimeAsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(4));
    }

    public Field98F setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field98F setComponent4(Calendar component4) {
        this.setComponent(4, SwiftFormatUtils.getTime2(component4));
        return this;
    }

    public Field98F setTime(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field98F setTime(Calendar component4) {
        this.setComponent4(component4);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return this.getComponent2();
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "98F";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c/[8c]/4!c<TIME2>";
    }

    public static Field98F get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("98F");
        if (t == null) {
            return null;
        }
        return new Field98F(t);
    }

    public static Field98F get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field98F.get(msg.getBlock4());
    }

    public static List<Field98F> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field98F.getAll(msg.getBlock4());
    }

    public static List<Field98F> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("98F");
        if (arr != null && arr.length > 0) {
            ArrayList<Field98F> result = new ArrayList<Field98F>(arr.length);
            for (Tag f : arr) {
                result.add(new Field98F(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 98F");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss", this.notNull(locale));
            Calendar cal = this.getComponent4AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Data Source Scheme");
        result.add("Code");
        result.add("Time");
        return result;
    }
}

