/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.field.Field;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwiftParseUtils {
    private static final transient Logger log = Logger.getLogger(SwiftParseUtils.class.getName());

    private SwiftParseUtils() {
        throw new AssertionError();
    }

    public static List<String> splitComponents(String line, String starting, String separator) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)line)) {
            String lineNoPrefix = SwiftParseUtils.removePrefix(line, starting);
            if (StringUtils.isNotBlank((String)separator)) {
                String[] tokens = StringUtils.splitByWholeSeparator((String)lineNoPrefix, (String)separator);
                for (int i = 0; i < tokens.length; ++i) {
                    if (!StringUtils.isNotBlank((String)tokens[i])) continue;
                    result.add(tokens[i]);
                }
            } else {
                result.add(lineNoPrefix);
            }
        }
        return result;
    }

    public static String getTokenFirst(String line, String starting, String separator) {
        String lineNoPrefix;
        String result = null;
        if (StringUtils.isNotBlank((String)line) && StringUtils.isBlank((String)(result = StringUtils.substringBefore((String)(lineNoPrefix = SwiftParseUtils.removePrefix(line, starting)), (String)separator)))) {
            return null;
        }
        return result;
    }

    public static String getTokenFirst(String line, String separator) {
        return SwiftParseUtils.getTokenFirst(line, null, separator);
    }

    public static String removePrefix(String value, String prefix) {
        if (StringUtils.isNotBlank((String)value) && StringUtils.isNotBlank((String)prefix) && value.startsWith(prefix)) {
            return StringUtils.substringAfter((String)value, (String)prefix);
        }
        return value;
    }

    public static String getTokenSecond(String line, String separator) {
        String result = SwiftParseUtils.getTokenFirst(StringUtils.substringAfter((String)line, (String)separator), null, separator);
        return result;
    }

    public static String getTokenSecondLast(String line, String separator) {
        String result = StringUtils.substringAfter((String)line, (String)separator);
        if (StringUtils.isBlank((String)result)) {
            result = null;
        }
        return result;
    }

    public static String getTokenSecond(String line, String starting, String separator) {
        return SwiftParseUtils.getTokenSecond(SwiftParseUtils.removePrefix(line, starting), separator);
    }

    public static String getTokenSecondLast(String line, String starting, String separator) {
        return SwiftParseUtils.getTokenSecondLast(SwiftParseUtils.removePrefix(line, starting), separator);
    }

    public static String getTokenThird(String line, String separator) {
        String result = SwiftParseUtils.getTokenSecond(SwiftParseUtils.getTokenSecondLast(line, separator), separator);
        return result;
    }

    public static String getTokenThirdLast(String line, String separator) {
        String result = null;
        String s1 = SwiftParseUtils.getTokenSecondLast(line, separator);
        if (StringUtils.isNotBlank((String)s1) && StringUtils.isBlank((String)(result = StringUtils.substringAfter((String)s1, (String)separator)))) {
            result = null;
        }
        return result;
    }

    public static String getTokenForth(String line, String separator) {
        String result = SwiftParseUtils.getTokenSecond(SwiftParseUtils.getTokenThirdLast(line, separator), separator);
        return result;
    }

    public static String getTokenForthLast(String line, String separator) {
        String result = null;
        String s1 = SwiftParseUtils.getTokenThirdLast(line, separator);
        if (StringUtils.isNotBlank((String)s1) && StringUtils.isBlank((String)(result = StringUtils.substringAfter((String)s1, (String)separator)))) {
            result = null;
        }
        return result;
    }

    public static String getAlphaPrefix(String value) {
        if (value != null && value.length() > 0) {
            int i;
            for (i = 0; i < value.length() && !StringUtils.isNumeric((String)Character.toString(value.charAt(i))); ++i) {
            }
            if (i > 0) {
                return StringUtils.substring((String)value, (int)0, (int)i);
            }
        }
        return null;
    }

    public static String getNumericPrefix(String value) {
        if (value != null && value.length() > 0) {
            int i;
            for (i = 0; i < value.length() && (StringUtils.isNumeric((String)Character.toString(value.charAt(i))) || value.charAt(i) == ','); ++i) {
            }
            if (i > 0) {
                return StringUtils.substring((String)value, (int)0, (int)i);
            }
        }
        return null;
    }

    public static String getNumericSuffix(String value) {
        if (value != null && value.length() > 0) {
            int i;
            for (i = 0; i < value.length() && !StringUtils.isNumeric((String)Character.toString(value.charAt(i))); ++i) {
            }
            if (i < value.length()) {
                return StringUtils.substring((String)value, (int)i);
            }
        }
        return null;
    }

    public static String getAlphaSuffix(String value) {
        if (value != null && value.length() > 0) {
            int i;
            for (i = 0; i < value.length() && (StringUtils.isNumeric((String)Character.toString(value.charAt(i))) || value.charAt(i) == ','); ++i) {
            }
            if (i < value.length()) {
                return StringUtils.substring((String)value, (int)i);
            }
        }
        return null;
    }

    public static List<String> getLines(String value) {
        ArrayList<String> result = new ArrayList<String>();
        if (value != null) {
            BufferedReader br = new BufferedReader(new StringReader(value));
            try {
                String l = br.readLine();
                while (l != null) {
                    result.add(l);
                    l = br.readLine();
                }
            }
            catch (IOException e) {
                throw new UnhandledException((Throwable)e);
            }
        }
        return result;
    }

    public static void setComponentsFromLines(Field f, int startingComponentNumber, Integer linesToSet, int startingLine, List<String> lines) {
        int max = linesToSet != null ? linesToSet.intValue() : lines.size();
        int componentNumber = startingComponentNumber;
        int lineNumber = startingLine;
        for (int i = 0; i < max; ++i) {
            if (lines.size() > lineNumber) {
                f.setComponent(componentNumber, lines.get(lineNumber));
            }
            ++componentNumber;
            ++lineNumber;
        }
    }

    public static void setComponentsFromTokens(Field f, int startingComponentNumber, int componentsToSet, int tokenSize, String value) {
        StringBuilder token = new StringBuilder();
        int componentNumber = startingComponentNumber;
        for (char c : value.toCharArray()) {
            if (token.length() < tokenSize) {
                token.append(c);
                continue;
            }
            if (componentNumber <= componentsToSet) {
                f.setComponent(componentNumber, token.toString());
            }
            ++componentNumber;
            token = new StringBuilder();
            token.append(c);
        }
        if (token.length() > 0 && componentNumber <= componentsToSet) {
            f.setComponent(componentNumber, token.toString());
        }
    }
}

