/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt1xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field21F;
import com.prowidesoftware.swift.model.field.Field21R;
import com.prowidesoftware.swift.model.field.Field23E;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field25A;
import com.prowidesoftware.swift.model.field.Field28D;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field33B;
import com.prowidesoftware.swift.model.field.Field36;
import com.prowidesoftware.swift.model.field.Field50C;
import com.prowidesoftware.swift.model.field.Field50F;
import com.prowidesoftware.swift.model.field.Field50G;
import com.prowidesoftware.swift.model.field.Field50H;
import com.prowidesoftware.swift.model.field.Field50L;
import com.prowidesoftware.swift.model.field.Field51A;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52C;
import com.prowidesoftware.swift.model.field.Field56A;
import com.prowidesoftware.swift.model.field.Field56C;
import com.prowidesoftware.swift.model.field.Field56D;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field57C;
import com.prowidesoftware.swift.model.field.Field57D;
import com.prowidesoftware.swift.model.field.Field59;
import com.prowidesoftware.swift.model.field.Field59A;
import com.prowidesoftware.swift.model.field.Field59F;
import com.prowidesoftware.swift.model.field.Field70;
import com.prowidesoftware.swift.model.field.Field71A;
import com.prowidesoftware.swift.model.field.Field77B;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT101
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT101.class.getName());
    public static final String NAME = "101";
    @Deprecated
    public static final String BEN = "BEN";
    @Deprecated
    public static final String CHQB = "CHQB";
    @Deprecated
    public static final String CMSW = "CMSW";
    @Deprecated
    public static final String CMTO = "CMTO";
    @Deprecated
    public static final String CMZB = "CMZB";
    @Deprecated
    public static final String CORT = "CORT";
    @Deprecated
    public static final String EQUI = "EQUI";
    @Deprecated
    public static final String INTC = "INTC";
    @Deprecated
    public static final String NETS = "NETS";
    @Deprecated
    public static final String OTHR = "OTHR";
    @Deprecated
    public static final String OUR = "OUR";
    @Deprecated
    public static final String PHON = "PHON";
    @Deprecated
    public static final String REPA = "REPA";
    @Deprecated
    public static final String RTGS = "RTGS";
    @Deprecated
    public static final String SHA = "SHA";
    @Deprecated
    public static final String URGP = "URGP";

    public MT101(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT101(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT101 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT101(m.message());
    }

    public MT101() {
        this("TESTUS00", "TESTUS00");
    }

    public MT101(String sender, String receiver) {
        super(101, sender, receiver);
    }

    @Deprecated
    public MT101(int messageType, String sender, String receiver) {
        super(101, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT101(int, String, String)", "Use the constructor MT101(sender, receiver) instead.");
    }

    public MT101(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT101.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT101 object from FIN content with a Service Message. Check if the MT101 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT101 object from FIN content with message type " + param.getType());
        }
    }

    public static MT101 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT101(fin);
    }

    public MT101(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT101 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT101(stream);
    }

    public MT101(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT101 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT101(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT101 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT101 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT101 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21R getField21R() {
        Tag t = this.tag("21R");
        if (t != null) {
            return new Field21R(t.getValue());
        }
        return null;
    }

    public Field28D getField28D() {
        Tag t = this.tag("28D");
        if (t != null) {
            return new Field28D(t.getValue());
        }
        return null;
    }

    public Field51A getField51A() {
        Tag t = this.tag("51A");
        if (t != null) {
            return new Field51A(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field25 getField25() {
        Tag t = this.tag("25");
        if (t != null) {
            return new Field25(t.getValue());
        }
        return null;
    }

    public List<Field21> getField21() {
        ArrayList<Field21> result = new ArrayList<Field21>();
        Tag[] tags = this.tags("21");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field21(tags[i].getValue()));
        }
        return result;
    }

    public List<Field21F> getField21F() {
        ArrayList<Field21F> result = new ArrayList<Field21F>();
        Tag[] tags = this.tags("21F");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field21F(tags[i].getValue()));
        }
        return result;
    }

    public List<Field23E> getField23E() {
        ArrayList<Field23E> result = new ArrayList<Field23E>();
        Tag[] tags = this.tags("23E");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field23E(tags[i].getValue()));
        }
        return result;
    }

    public List<Field32B> getField32B() {
        ArrayList<Field32B> result = new ArrayList<Field32B>();
        Tag[] tags = this.tags("32B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field32B(tags[i].getValue()));
        }
        return result;
    }

    public List<Field50C> getField50C() {
        ArrayList<Field50C> result = new ArrayList<Field50C>();
        Tag[] tags = this.tags("50C");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field50C(tags[i].getValue()));
        }
        return result;
    }

    public List<Field50L> getField50L() {
        ArrayList<Field50L> result = new ArrayList<Field50L>();
        Tag[] tags = this.tags("50L");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field50L(tags[i].getValue()));
        }
        return result;
    }

    public List<Field50F> getField50F() {
        ArrayList<Field50F> result = new ArrayList<Field50F>();
        Tag[] tags = this.tags("50F");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field50F(tags[i].getValue()));
        }
        return result;
    }

    public List<Field50G> getField50G() {
        ArrayList<Field50G> result = new ArrayList<Field50G>();
        Tag[] tags = this.tags("50G");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field50G(tags[i].getValue()));
        }
        return result;
    }

    public List<Field50H> getField50H() {
        ArrayList<Field50H> result = new ArrayList<Field50H>();
        Tag[] tags = this.tags("50H");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field50H(tags[i].getValue()));
        }
        return result;
    }

    public List<Field52A> getField52A() {
        ArrayList<Field52A> result = new ArrayList<Field52A>();
        Tag[] tags = this.tags("52A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field52A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field52C> getField52C() {
        ArrayList<Field52C> result = new ArrayList<Field52C>();
        Tag[] tags = this.tags("52C");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field52C(tags[i].getValue()));
        }
        return result;
    }

    public List<Field56A> getField56A() {
        ArrayList<Field56A> result = new ArrayList<Field56A>();
        Tag[] tags = this.tags("56A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field56A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field56C> getField56C() {
        ArrayList<Field56C> result = new ArrayList<Field56C>();
        Tag[] tags = this.tags("56C");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field56C(tags[i].getValue()));
        }
        return result;
    }

    public List<Field56D> getField56D() {
        ArrayList<Field56D> result = new ArrayList<Field56D>();
        Tag[] tags = this.tags("56D");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field56D(tags[i].getValue()));
        }
        return result;
    }

    public List<Field57A> getField57A() {
        ArrayList<Field57A> result = new ArrayList<Field57A>();
        Tag[] tags = this.tags("57A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field57A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field57C> getField57C() {
        ArrayList<Field57C> result = new ArrayList<Field57C>();
        Tag[] tags = this.tags("57C");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field57C(tags[i].getValue()));
        }
        return result;
    }

    public List<Field57D> getField57D() {
        ArrayList<Field57D> result = new ArrayList<Field57D>();
        Tag[] tags = this.tags("57D");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field57D(tags[i].getValue()));
        }
        return result;
    }

    public List<Field59A> getField59A() {
        ArrayList<Field59A> result = new ArrayList<Field59A>();
        Tag[] tags = this.tags("59A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field59A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field59F> getField59F() {
        ArrayList<Field59F> result = new ArrayList<Field59F>();
        Tag[] tags = this.tags("59F");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field59F(tags[i].getValue()));
        }
        return result;
    }

    public List<Field59> getField59() {
        ArrayList<Field59> result = new ArrayList<Field59>();
        Tag[] tags = this.tags("59");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field59(tags[i].getValue()));
        }
        return result;
    }

    public List<Field70> getField70() {
        ArrayList<Field70> result = new ArrayList<Field70>();
        Tag[] tags = this.tags("70");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field70(tags[i].getValue()));
        }
        return result;
    }

    public List<Field77B> getField77B() {
        ArrayList<Field77B> result = new ArrayList<Field77B>();
        Tag[] tags = this.tags("77B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field77B(tags[i].getValue()));
        }
        return result;
    }

    public List<Field33B> getField33B() {
        ArrayList<Field33B> result = new ArrayList<Field33B>();
        Tag[] tags = this.tags("33B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field33B(tags[i].getValue()));
        }
        return result;
    }

    public List<Field71A> getField71A() {
        ArrayList<Field71A> result = new ArrayList<Field71A>();
        Tag[] tags = this.tags("71A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field71A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field25A> getField25A() {
        ArrayList<Field25A> result = new ArrayList<Field25A>();
        Tag[] tags = this.tags("25A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field25A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field36> getField36() {
        ArrayList<Field36> result = new ArrayList<Field36>();
        Tag[] tags = this.tags("36");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field36(tags[i].getValue()));
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return this.getSequenceA(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            SwiftTagListBlock content = parentSequence.getSubBlockDelimitedWithOptionalTail(SequenceA.START, SequenceA.END, SequenceA.TAIL);
            if (log.isLoggable(Level.FINE)) {
                if (content == null) {
                    log.fine("content for sequence SequenceA: is null");
                } else {
                    log.fine("content for sequence SequenceA: " + content.tagNamesList());
                }
            }
            if (content == null) {
                return new SequenceA();
            }
            return new SequenceA(content);
        }
        return null;
    }

    public List<SequenceB> getSequenceBList() {
        return MT101.getSequenceBList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceB> getSequenceBList(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            ArrayList<SequenceB> result = new ArrayList<SequenceB>();
            List<SwiftTagListBlock> bs = parentSequence.getSubBlocksDelimitedWithOptionalTail(SequenceB.START, SequenceB.END, SequenceB.TAIL);
            if (bs != null && !bs.isEmpty()) {
                for (SwiftTagListBlock s : bs) {
                    result.add(new SequenceB(s));
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"21"};
        protected static final String[] END = new String[]{"71A"};
        protected static final String[] TAIL = new String[]{"25A", "36"};

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            return SequenceB.newInstance(0, 0, tags);
        }

        public static SequenceB newInstance(int start, int end, Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"20"};
        protected static final String[] END = new String[]{"30"};
        protected static final String[] TAIL = new String[]{"25"};

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            return SequenceA.newInstance(0, 0, tags);
        }

        public static SequenceA newInstance(int start, int end, Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

