/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt1xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52B;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field59;
import com.prowidesoftware.swift.model.field.Field75;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT111
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT111.class.getName());
    public static final String NAME = "111";

    public MT111(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT111(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT111 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT111(m.message());
    }

    public MT111() {
        this("TESTUS00", "TESTUS00");
    }

    public MT111(String sender, String receiver) {
        super(111, sender, receiver);
    }

    @Deprecated
    public MT111(int messageType, String sender, String receiver) {
        super(111, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT111(int, String, String)", "Use the constructor MT111(sender, receiver) instead.");
    }

    public MT111(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT111.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT111 object from FIN content with a Service Message. Check if the MT111 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT111 object from FIN content with message type " + param.getType());
        }
    }

    public static MT111 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT111(fin);
    }

    public MT111(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT111 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT111(stream);
    }

    public MT111(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT111 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT111(file);
    }

    public String getMessageType() {
        return NAME;
    }

    public MT111 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    public MT111 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    public MT111 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field32A getField32A() {
        Tag t = this.tag("32A");
        if (t != null) {
            return new Field32A(t.getValue());
        }
        return null;
    }

    public Field32B getField32B() {
        Tag t = this.tag("32B");
        if (t != null) {
            return new Field32B(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52B getField52B() {
        Tag t = this.tag("52B");
        if (t != null) {
            return new Field52B(t.getValue());
        }
        return null;
    }

    public Field52D getField52D() {
        Tag t = this.tag("52D");
        if (t != null) {
            return new Field52D(t.getValue());
        }
        return null;
    }

    public Field59 getField59() {
        Tag t = this.tag("59");
        if (t != null) {
            return new Field59(t.getValue());
        }
        return null;
    }

    public Field75 getField75() {
        Tag t = this.tag("75");
        if (t != null) {
            return new Field75(t.getValue());
        }
        return null;
    }
}

