/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt2xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field21R;
import com.prowidesoftware.swift.model.field.Field23E;
import com.prowidesoftware.swift.model.field.Field28D;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field51A;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52C;
import com.prowidesoftware.swift.model.field.Field52G;
import com.prowidesoftware.swift.model.field.Field56A;
import com.prowidesoftware.swift.model.field.Field56D;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field57C;
import com.prowidesoftware.swift.model.field.Field57D;
import com.prowidesoftware.swift.model.field.Field58A;
import com.prowidesoftware.swift.model.field.Field58D;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT207
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT207.class.getName());
    public static final String NAME = "207";
    @Deprecated
    public static final String CMSW = "CMSW";
    @Deprecated
    public static final String CMTO = "CMTO";
    @Deprecated
    public static final String CMZB = "CMZB";
    @Deprecated
    public static final String CORT = "CORT";
    @Deprecated
    public static final String NETS = "NETS";
    @Deprecated
    public static final String OTHR = "OTHR";
    @Deprecated
    public static final String PHON = "PHON";
    @Deprecated
    public static final String RTGS = "RTGS";
    @Deprecated
    public static final String URGP = "URGP";

    public MT207(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT207(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT207 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT207(m.message());
    }

    public MT207() {
        this("TESTUS00", "TESTUS00");
    }

    public MT207(String sender, String receiver) {
        super(207, sender, receiver);
    }

    @Deprecated
    public MT207(int messageType, String sender, String receiver) {
        super(207, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT207(int, String, String)", "Use the constructor MT207(sender, receiver) instead.");
    }

    public MT207(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT207.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT207 object from FIN content with a Service Message. Check if the MT207 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT207 object from FIN content with message type " + param.getType());
        }
    }

    public static MT207 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT207(fin);
    }

    public MT207(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT207 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT207(stream);
    }

    public MT207(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT207 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT207(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT207 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT207 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT207 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21R getField21R() {
        Tag t = this.tag("21R");
        if (t != null) {
            return new Field21R(t.getValue());
        }
        return null;
    }

    public Field28D getField28D() {
        Tag t = this.tag("28D");
        if (t != null) {
            return new Field28D(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field51A getField51A() {
        Tag t = this.tag("51A");
        if (t != null) {
            return new Field51A(t.getValue());
        }
        return null;
    }

    public Field52G getField52G() {
        Tag t = this.tag("52G");
        if (t != null) {
            return new Field52G(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52C getField52C() {
        Tag t = this.tag("52C");
        if (t != null) {
            return new Field52C(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public List<Field21> getField21() {
        ArrayList<Field21> result = new ArrayList<Field21>();
        Tag[] tags = this.tags("21");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field21(tags[i].getValue()));
        }
        return result;
    }

    public List<Field23E> getField23E() {
        ArrayList<Field23E> result = new ArrayList<Field23E>();
        Tag[] tags = this.tags("23E");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field23E(tags[i].getValue()));
        }
        return result;
    }

    public List<Field32B> getField32B() {
        ArrayList<Field32B> result = new ArrayList<Field32B>();
        Tag[] tags = this.tags("32B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field32B(tags[i].getValue()));
        }
        return result;
    }

    public List<Field56A> getField56A() {
        ArrayList<Field56A> result = new ArrayList<Field56A>();
        Tag[] tags = this.tags("56A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field56A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field56D> getField56D() {
        ArrayList<Field56D> result = new ArrayList<Field56D>();
        Tag[] tags = this.tags("56D");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field56D(tags[i].getValue()));
        }
        return result;
    }

    public List<Field57A> getField57A() {
        ArrayList<Field57A> result = new ArrayList<Field57A>();
        Tag[] tags = this.tags("57A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field57A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field57C> getField57C() {
        ArrayList<Field57C> result = new ArrayList<Field57C>();
        Tag[] tags = this.tags("57C");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field57C(tags[i].getValue()));
        }
        return result;
    }

    public List<Field57D> getField57D() {
        ArrayList<Field57D> result = new ArrayList<Field57D>();
        Tag[] tags = this.tags("57D");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field57D(tags[i].getValue()));
        }
        return result;
    }

    public List<Field58A> getField58A() {
        ArrayList<Field58A> result = new ArrayList<Field58A>();
        Tag[] tags = this.tags("58A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field58A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field58D> getField58D() {
        ArrayList<Field58D> result = new ArrayList<Field58D>();
        Tag[] tags = this.tags("58D");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field58D(tags[i].getValue()));
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return this.getSequenceA(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            SwiftTagListBlock content = parentSequence.getSubBlockDelimitedWithOptionalTail(SequenceA.START, SequenceA.END, SequenceA.TAIL);
            if (log.isLoggable(Level.FINE)) {
                if (content == null) {
                    log.fine("content for sequence SequenceA: is null");
                } else {
                    log.fine("content for sequence SequenceA: " + content.tagNamesList());
                }
            }
            if (content == null) {
                return new SequenceA();
            }
            return new SequenceA(content);
        }
        return null;
    }

    public List<SequenceB> getSequenceBList() {
        return MT207.getSequenceBList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceB> getSequenceBList(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            ArrayList<SequenceB> result = new ArrayList<SequenceB>();
            List<SwiftTagListBlock> bs = parentSequence.getSubBlocksDelimitedWithOptionalTail(SequenceB.START, SequenceB.END, SequenceB.TAIL);
            if (bs != null && !bs.isEmpty()) {
                for (SwiftTagListBlock s : bs) {
                    result.add(new SequenceB(s));
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"21"};
        protected static final String[] END = new String[]{"58A", "58D"};
        protected static final String[] TAIL = new String[0];

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            return SequenceB.newInstance(0, 0, tags);
        }

        public static SequenceB newInstance(int start, int end, Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"20"};
        protected static final String[] END = new String[]{"52G"};
        protected static final String[] TAIL = new String[]{"52A", "52C", "72"};

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            return SequenceA.newInstance(0, 0, tags);
        }

        public static SequenceA newInstance(int start, int end, Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

