/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt4xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field33C;
import com.prowidesoftware.swift.model.field.Field33D;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52B;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field77A;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT455
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT455.class.getName());
    public static final String NAME = "455";

    public MT455(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT455(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT455 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT455(m.message());
    }

    public MT455() {
        this("TESTUS00", "TESTUS00");
    }

    public MT455(String sender, String receiver) {
        super(455, sender, receiver);
    }

    @Deprecated
    public MT455(int messageType, String sender, String receiver) {
        super(455, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT455(int, String, String)", "Use the constructor MT455(sender, receiver) instead.");
    }

    public MT455(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT455.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT455 object from FIN content with a Service Message. Check if the MT455 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT455 object from FIN content with message type " + param.getType());
        }
    }

    public static MT455 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT455(fin);
    }

    public MT455(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT455 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT455(stream);
    }

    public MT455(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT455 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT455(file);
    }

    public String getMessageType() {
        return NAME;
    }

    public MT455 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    public MT455 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    public MT455 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field25 getField25() {
        Tag t = this.tag("25");
        if (t != null) {
            return new Field25(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field32A getField32A() {
        Tag t = this.tag("32A");
        if (t != null) {
            return new Field32A(t.getValue());
        }
        return null;
    }

    public Field33C getField33C() {
        Tag t = this.tag("33C");
        if (t != null) {
            return new Field33C(t.getValue());
        }
        return null;
    }

    public Field33D getField33D() {
        Tag t = this.tag("33D");
        if (t != null) {
            return new Field33D(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52B getField52B() {
        Tag t = this.tag("52B");
        if (t != null) {
            return new Field52B(t.getValue());
        }
        return null;
    }

    public Field52D getField52D() {
        Tag t = this.tag("52D");
        if (t != null) {
            return new Field52D(t.getValue());
        }
        return null;
    }

    public Field77A getField77A() {
        Tag t = this.tag("77A");
        if (t != null) {
            return new Field77A(t.getValue());
        }
        return null;
    }
}

