/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt6xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field26C;
import com.prowidesoftware.swift.model.field.Field27;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field31C;
import com.prowidesoftware.swift.model.field.Field68B;
import com.prowidesoftware.swift.model.field.Field68C;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT609
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT609.class.getName());
    public static final String NAME = "609";
    @Deprecated
    public static final String ALLOC = "ALLOC";
    @Deprecated
    public static final String ALUM = "ALUM";
    @Deprecated
    public static final String AMEG = "AMEG";
    @Deprecated
    public static final String ANUG = "ANUG";
    @Deprecated
    public static final String BRIT = "BRIT";
    @Deprecated
    public static final String CFR = "CFR";
    @Deprecated
    public static final String CIF = "CIF";
    @Deprecated
    public static final String CIP = "CIP";
    @Deprecated
    public static final String COIN = "COIN";
    @Deprecated
    public static final String COPP = "COPP";
    @Deprecated
    public static final String CORO = "CORO";
    @Deprecated
    public static final String CPT = "CPT";
    @Deprecated
    public static final String DAF = "DAF";
    @Deprecated
    public static final String DDP = "DDP";
    @Deprecated
    public static final String DDU = "DDU";
    @Deprecated
    public static final String DEQ = "DEQ";
    @Deprecated
    public static final String DES = "DES";
    @Deprecated
    public static final String DTD = "DTD";
    @Deprecated
    public static final String DUCA = "DUCA";
    @Deprecated
    public static final String EXW = "EXW";
    @Deprecated
    public static final String FAS = "FAS";
    @Deprecated
    public static final String FCA = "FCA";
    @Deprecated
    public static final String FOB = "FOB";
    @Deprecated
    public static final String FORWARDS = "FORWARDS";
    @Deprecated
    public static final String FOZ = "FOZ";
    @Deprecated
    public static final String FRFR = "FRFR";
    @Deprecated
    public static final String GECU = "GECU";
    @Deprecated
    public static final String GOLD = "GOLD";
    @Deprecated
    public static final String GOZ = "GOZ";
    @Deprecated
    public static final String GRM = "GRM";
    @Deprecated
    public static final String IRID = "IRID";
    @Deprecated
    public static final String KLO = "KLO";
    @Deprecated
    public static final String KRUG = "KRUG";
    @Deprecated
    public static final String LBTY = "LBTY";
    @Deprecated
    public static final String LEAD = "LEAD";
    @Deprecated
    public static final String LIT = "LIT";
    @Deprecated
    public static final String LOC = "LOC";
    @Deprecated
    public static final String LOT = "LOT";
    @Deprecated
    public static final String MAPL = "MAPL";
    @Deprecated
    public static final String MEXP = "MEXP";
    @Deprecated
    public static final String NBUF = "NBUF";
    @Deprecated
    public static final String NICK = "NICK";
    @Deprecated
    public static final String NOBL = "NOBL";
    @Deprecated
    public static final String NSOV = "NSOV";
    @Deprecated
    public static final String OPTIONS = "OPTIONS";
    @Deprecated
    public static final String OSMI = "OSMI";
    @Deprecated
    public static final String OSOV = "OSOV";
    @Deprecated
    public static final String OTH = "OTH";
    @Deprecated
    public static final String OTHR = "OTHR";
    @Deprecated
    public static final String PALL = "PALL";
    @Deprecated
    public static final String PLAT = "PLAT";
    @Deprecated
    public static final String PND = "PND";
    @Deprecated
    public static final String POIL = "POIL";
    @Deprecated
    public static final String RHOD = "RHOD";
    @Deprecated
    public static final String RUTH = "RUTH";
    @Deprecated
    public static final String SAEG = "SAEG";
    @Deprecated
    public static final String SECU = "SECU";
    @Deprecated
    public static final String SILV = "SILV";
    @Deprecated
    public static final String SPOTS = "SPOTS";
    @Deprecated
    public static final String STAT = "STAT";
    @Deprecated
    public static final String STEE = "STEE";
    @Deprecated
    public static final String TAL = "TAL";
    @Deprecated
    public static final String TINA = "TINA";
    @Deprecated
    public static final String TITA = "TITA";
    @Deprecated
    public static final String TOL = "TOL";
    @Deprecated
    public static final String TON = "TON";
    @Deprecated
    public static final String TOZ = "TOZ";
    @Deprecated
    public static final String UNALL = "UNALL";
    @Deprecated
    public static final String UNT = "UNT";
    @Deprecated
    public static final String VREN = "VREN";
    @Deprecated
    public static final String ZINC = "ZINC";

    public MT609(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT609(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT609 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT609(m.message());
    }

    public MT609() {
        this("TESTUS00", "TESTUS00");
    }

    public MT609(String sender, String receiver) {
        super(609, sender, receiver);
    }

    @Deprecated
    public MT609(int messageType, String sender, String receiver) {
        super(609, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT609(int, String, String)", "Use the constructor MT609(sender, receiver) instead.");
    }

    public MT609(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT609.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT609 object from FIN content with a Service Message. Check if the MT609 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT609 object from FIN content with message type " + param.getType());
        }
    }

    public static MT609 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT609(fin);
    }

    public MT609(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT609 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT609(stream);
    }

    public MT609(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT609 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT609(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT609 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT609 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT609 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field27 getField27() {
        Tag t = this.tag("27");
        if (t != null) {
            return new Field27(t.getValue());
        }
        return null;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field31C getField31C() {
        Tag t = this.tag("31C");
        if (t != null) {
            return new Field31C(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public List<Field23> getField23() {
        ArrayList<Field23> result = new ArrayList<Field23>();
        Tag[] tags = this.tags("23");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field23(tags[i].getValue()));
        }
        return result;
    }

    public List<Field26C> getField26C() {
        ArrayList<Field26C> result = new ArrayList<Field26C>();
        Tag[] tags = this.tags("26C");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field26C(tags[i].getValue()));
        }
        return result;
    }

    public List<Field68B> getField68B() {
        ArrayList<Field68B> result = new ArrayList<Field68B>();
        Tag[] tags = this.tags("68B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field68B(tags[i].getValue()));
        }
        return result;
    }

    public List<Field68C> getField68C() {
        ArrayList<Field68C> result = new ArrayList<Field68C>();
        Tag[] tags = this.tags("68C");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field68C(tags[i].getValue()));
        }
        return result;
    }

    public List<Field72> getField72() {
        ArrayList<Field72> result = new ArrayList<Field72>();
        Tag[] tags = this.tags("72");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field72(tags[i].getValue()));
        }
        return result;
    }

    public List<SwiftTagListBlock> getSequence23_72List() {
        if (this.getSwiftMessage() == null) {
            return Collections.emptyList();
        }
        SwiftBlock4 b4 = this.getSwiftMessage().getBlock4();
        if (b4 == null || b4.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<Tag> it = b4.tagIterator();
        ArrayList<SwiftTagListBlock> result = new ArrayList<SwiftTagListBlock>();
        SwiftTagListBlock currentBlock = null;
        while (it.hasNext()) {
            Tag t = it.next();
            if ("23".equals(t.getName())) {
                if (currentBlock != null) {
                    result.add(currentBlock);
                }
                currentBlock = new SwiftTagListBlock();
            }
            if (currentBlock == null) continue;
            currentBlock.append(t);
        }
        if (currentBlock != null) {
            result.add(currentBlock);
        }
        return result;
    }
}

