/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt6xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field27;
import com.prowidesoftware.swift.model.field.Field29A;
import com.prowidesoftware.swift.model.field.Field29B;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field79;
import com.prowidesoftware.swift.model.field.Field88D;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT649
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT649.class.getName());
    public static final String NAME = "649";

    public MT649(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT649(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT649 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT649(m.message());
    }

    public MT649() {
        this("TESTUS00", "TESTUS00");
    }

    public MT649(String sender, String receiver) {
        super(649, sender, receiver);
    }

    @Deprecated
    public MT649(int messageType, String sender, String receiver) {
        super(649, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT649(int, String, String)", "Use the constructor MT649(sender, receiver) instead.");
    }

    public MT649(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT649.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT649 object from FIN content with a Service Message. Check if the MT649 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT649 object from FIN content with message type " + param.getType());
        }
    }

    public static MT649 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT649(fin);
    }

    public MT649(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT649 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT649(stream);
    }

    public MT649(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT649 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT649(file);
    }

    public String getMessageType() {
        return NAME;
    }

    public MT649 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    public MT649 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    public MT649 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field27 getField27() {
        Tag t = this.tag("27");
        if (t != null) {
            return new Field27(t.getValue());
        }
        return null;
    }

    public Field29A getField29A() {
        Tag t = this.tag("29A");
        if (t != null) {
            return new Field29A(t.getValue());
        }
        return null;
    }

    public Field29B getField29B() {
        Tag t = this.tag("29B");
        if (t != null) {
            return new Field29B(t.getValue());
        }
        return null;
    }

    public Field88D getField88D() {
        Tag t = this.tag("88D");
        if (t != null) {
            return new Field88D(t.getValue());
        }
        return null;
    }

    public Field32A getField32A() {
        Tag t = this.tag("32A");
        if (t != null) {
            return new Field32A(t.getValue());
        }
        return null;
    }

    public Field32B getField32B() {
        Tag t = this.tag("32B");
        if (t != null) {
            return new Field32B(t.getValue());
        }
        return null;
    }

    public Field79 getField79() {
        Tag t = this.tag("79");
        if (t != null) {
            return new Field79(t.getValue());
        }
        return null;
    }
}

