/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt6xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field11S;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field79;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT692
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT692.class.getName());
    public static final String NAME = "692";

    public MT692(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT692(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT692 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT692(m.message());
    }

    public MT692() {
        this("TESTUS00", "TESTUS00");
    }

    public MT692(String sender, String receiver) {
        super(692, sender, receiver);
    }

    @Deprecated
    public MT692(int messageType, String sender, String receiver) {
        super(692, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT692(int, String, String)", "Use the constructor MT692(sender, receiver) instead.");
    }

    public MT692(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT692.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT692 object from FIN content with a Service Message. Check if the MT692 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT692 object from FIN content with message type " + param.getType());
        }
    }

    public static MT692 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT692(fin);
    }

    public MT692(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT692 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT692(stream);
    }

    public MT692(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT692 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT692(file);
    }

    public String getMessageType() {
        return NAME;
    }

    public MT692 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    public MT692 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    public MT692 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field11S getField11S() {
        Tag t = this.tag("11S");
        if (t != null) {
            return new Field11S(t.getValue());
        }
        return null;
    }

    public Field79 getField79() {
        Tag t = this.tag("79");
        if (t != null) {
            return new Field79(t.getValue());
        }
        return null;
    }
}

