/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class XmlEventWriter
implements XMLEventWriter {
    private static final transient Logger log = Logger.getLogger(XmlEventWriter.class.getName());
    private static final Level STEP_LEVEL = Level.FINER;
    private Writer out;
    private final StringBuilder indent = new StringBuilder();
    private StartElement delayedStart = null;
    private boolean startTagIncomplete = false;
    private int startElementCount;
    private final StringBuilder stepOutLog;
    private String prefix = null;
    private boolean includeXMLDeclaration = true;
    private String rootElement = null;

    public XmlEventWriter(Writer baos, String prefix, boolean includeXMLDeclaration, String rootElement) {
        this.out = baos;
        this.stepOutLog = log.isLoggable(STEP_LEVEL) ? new StringBuilder() : null;
        this.startElementCount = 0;
        this.prefix = prefix;
        this.includeXMLDeclaration = includeXMLDeclaration;
        this.rootElement = rootElement;
    }

    public void add(XMLEvent event) throws XMLStreamException {
        if (event != null) {
            log.finest("XmlEventType: " + event.getEventType());
            try {
                int type = event.getEventType();
                switch (type) {
                    case 7: {
                        if (this.includeXMLDeclaration) {
                            log.finer(">> START_DOCUMENT");
                            log.finer("START_DOCUMENT XMLEvent " + ToStringBuilder.reflectionToString((Object)event));
                            String str = "<?xml version=\"1.0\" encoding=\"" + ((StartDocument)event).getCharacterEncodingScheme() + "\"?>";
                            this.out.write(str);
                            this.logStep(str);
                            break;
                        }
                        log.finer("skipping xml declaration");
                        break;
                    }
                    case 1: {
                        ++this.startElementCount;
                        this.closeStartTagIfNeeded();
                        log.finer(">> START_ELEMENT");
                        this.indent.append(' ');
                        StartElement se = event.asStartElement();
                        Iterator<Namespace> it = se.getNamespaces();
                        while (it.hasNext()) {
                            log.fine("ns: " + it.next());
                        }
                        if (StringUtils.equals((String)se.getName().getLocalPart(), (String)this.rootElement) && this.startElementCount == 1) {
                            this.delayedStart = se;
                            log.finer("local part is Document, initializing delayed start, startElementCount=" + this.startElementCount);
                            break;
                        }
                        String s = "\n" + this.indent + "<" + this.prefix() + se.getName().getLocalPart();
                        this.out.write(s);
                        this.logStep(s);
                        this.startTagIncomplete = true;
                        if (se.isNamespace()) {
                            log.fine("is ns in start XMLEvent " + ToStringBuilder.reflectionToString((Object)event));
                        }
                        break;
                    }
                    case 13: {
                        log.finer(">> NAMESPACE");
                        Namespace ne = (Namespace)event;
                        if (this.delayedStart != null) {
                            String s = "\n" + this.indent + "<" + this.prefix() + this.delayedStart.getName().getLocalPart() + " " + "xmlns" + (this.prefix != null ? ":" + this.prefix : "") + "=\"" + ne.getValue() + "\" xmlns:xsi=\"" + ne.getName() + "\"" + ">";
                            this.out.write(s);
                            this.logStep(s);
                            this.delayedStart = null;
                            break;
                        }
                        log.fine("NAMESPACE XMLEvent " + ToStringBuilder.reflectionToString((Object)event));
                        break;
                    }
                    case 4: {
                        log.finer(">> CHARACTERS");
                        this.closeStartTagIfNeeded();
                        Characters ce = event.asCharacters();
                        char[] arr = ce.getData().toCharArray();
                        this.out.write(this.escape(arr));
                        this.logStep(ce.getData());
                        break;
                    }
                    case 2: {
                        log.finer(">> END_ELEMENT");
                        this.closeStartTagIfNeeded();
                        this.indent.deleteCharAt(0);
                        EndElement ee = event.asEndElement();
                        String str2 = "</" + this.prefix() + ee.getName().getLocalPart() + ">\n" + this.indent;
                        this.out.write(str2);
                        this.logStep(str2);
                        break;
                    }
                    case 8: {
                        log.finer(">> END_DOCUMENT");
                        this.closeStartTagIfNeeded();
                        log.finer("END_DOCUMENT XMLEvent " + ToStringBuilder.reflectionToString((Object)event));
                        break;
                    }
                    case 10: {
                        log.finer(">> ATTRIBUTE");
                        Attribute a = (Attribute)event;
                        String str3 = " " + a.getName() + "=\"" + a.getValue() + "\" ";
                        this.out.write(str3);
                        log.fine(ToStringBuilder.reflectionToString((Object)a));
                        this.logStep(str3);
                        break;
                    }
                    default: {
                        log.info("getEventType " + event.getEventType());
                        log.info("PW Unhandled XMLEvent " + ToStringBuilder.reflectionToString((Object)event));
                    }
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "PW I/O error: " + e);
                log.log(Level.FINER, "PW I/O error: ", e);
                throw new XMLStreamException(e);
            }
        }
    }

    private String escape(char[] arr) {
        StringBuilder sb = new StringBuilder(arr.length);
        block6: for (int i = 0; i < arr.length; ++i) {
            switch (arr[i]) {
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append('\"');
                    continue block6;
                }
                default: {
                    if (arr[i] > '\u007f') {
                        sb.append("&#");
                        sb.append(Integer.toString(arr[i]));
                        sb.append(';');
                        continue block6;
                    }
                    sb.append(arr[i]);
                }
            }
        }
        return sb.toString();
    }

    private String prefix() {
        if (this.prefix != null) {
            return this.prefix + ":";
        }
        return "";
    }

    private void logStep(String str) {
        if (log.isLoggable(STEP_LEVEL)) {
            this.stepOutLog.append(str);
            log.log(STEP_LEVEL, this.stepOutLog.toString());
        }
    }

    private void closeStartTagIfNeeded() throws IOException {
        if (this.startTagIncomplete) {
            this.out.write(62);
            this.logStep(">");
            this.startTagIncomplete = false;
        }
    }

    public void add(XMLEventReader arg0) throws XMLStreamException {
        log.fine("ADD EventReader: " + ToStringBuilder.reflectionToString((Object)arg0));
    }

    public void close() throws XMLStreamException {
        log.fine("close ");
    }

    public void flush() throws XMLStreamException {
        log.fine("flush ");
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public NamespaceContext getNamespaceContext() {
        return new ProwideNamespaceContext();
    }

    public String getPrefix(String arg0) throws XMLStreamException {
        log.fine("ADD EventReader: " + ToStringBuilder.reflectionToString((Object)arg0));
        return null;
    }

    public void setDefaultNamespace(String arg0) throws XMLStreamException {
        log.fine("ADD EventReader: " + ToStringBuilder.reflectionToString((Object)arg0));
    }

    public void setNamespaceContext(NamespaceContext arg0) throws XMLStreamException {
        log.fine("ADD EventReader: " + ToStringBuilder.reflectionToString((Object)arg0));
    }

    public void setPrefix(String arg0, String arg1) throws XMLStreamException {
        log.fine("ADD EventReader: " + ToStringBuilder.reflectionToString((Object)arg0) + ", " + ToStringBuilder.reflectionToString((Object)arg1));
    }

    private static final class ProwideNamespaceContext
    implements NamespaceContext {
        private static final transient Logger log = Logger.getLogger(ProwideNamespaceContext.class.getName());

        private ProwideNamespaceContext() {
        }

        public String getNamespaceURI(String prefix) {
            log.finest("getNamespaceURI(" + ToStringBuilder.reflectionToString((Object)prefix) + ")");
            return null;
        }

        public String getPrefix(String namespaceURI) {
            log.finest("getPrefix(" + ToStringBuilder.reflectionToString((Object)namespaceURI) + ")");
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            log.finest("getPrefixes(" + ToStringBuilder.reflectionToString((Object)namespaceURI) + ")");
            return null;
        }
    }
}

