/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.util.Calendar;
import java.util.logging.Logger;

public class MIR {
    private static final transient Logger log = Logger.getLogger(MIR.class.getName());
    private String date;
    private String logicalTerminal;
    private String sessionNumber;
    private String sequenceNumber;

    public MIR(String date, String logicalTerminal, String sessionNumber, String sequenceNumber) {
        this.date = date;
        this.logicalTerminal = logicalTerminal;
        this.sessionNumber = sessionNumber;
        this.sequenceNumber = sequenceNumber;
    }

    public MIR(String value) {
        if (value != null && value.length() == 28) {
            StringBuilder sb = new StringBuilder(value);
            int offset = 0;
            int len = 6;
            this.date = String.valueOf(sb.subSequence(offset, offset + len));
            offset += len;
            len = 12;
            this.logicalTerminal = String.valueOf(sb.subSequence(offset, offset + len));
            offset += len;
            len = 4;
            this.sessionNumber = String.valueOf(sb.subSequence(offset, offset + len));
            offset += len;
            len = 6;
            this.sequenceNumber = String.valueOf(sb.subSequence(offset, offset + len));
        } else {
            log.severe("invalid MIR value " + value);
        }
    }

    public MIR() {
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getLogicalTerminal() {
        return this.logicalTerminal;
    }

    public void setLogicalTerminal(String logicalTerminal) {
        this.logicalTerminal = logicalTerminal;
    }

    public String getSessionNumber() {
        return this.sessionNumber;
    }

    public void setSessionNumber(String sessionNumber) {
        this.sessionNumber = sessionNumber;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getMIR() {
        if (this.date == null && this.logicalTerminal == null && this.sessionNumber == null && this.sequenceNumber == null) {
            return null;
        }
        StringBuilder v = new StringBuilder();
        if (this.date != null) {
            v.append(this.date);
        }
        if (this.logicalTerminal != null) {
            v.append(this.logicalTerminal);
        }
        if (this.sessionNumber != null) {
            v.append(this.sessionNumber);
        }
        if (this.sequenceNumber != null) {
            v.append(this.sequenceNumber);
        }
        return v.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.logicalTerminal == null ? 0 : this.logicalTerminal.hashCode());
        result = 31 * result + (this.sequenceNumber == null ? 0 : this.sequenceNumber.hashCode());
        result = 31 * result + (this.sessionNumber == null ? 0 : this.sessionNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MIR other = (MIR)obj;
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.logicalTerminal == null ? other.logicalTerminal != null : !this.logicalTerminal.equals(other.logicalTerminal)) {
            return false;
        }
        if (this.sequenceNumber == null ? other.sequenceNumber != null : !this.sequenceNumber.equals(other.sequenceNumber)) {
            return false;
        }
        return !(this.sessionNumber == null ? other.sessionNumber != null : !this.sessionNumber.equals(other.sessionNumber));
    }

    public final Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.date);
    }
}

