/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.io.parser.SwiftParser;
import com.prowidesoftware.swift.io.writer.XMLWriterVisitor;
import com.prowidesoftware.swift.model.MessageIOType;
import com.prowidesoftware.swift.model.MtId;
import com.prowidesoftware.swift.model.SequenceNode;
import com.prowidesoftware.swift.model.SwiftBlock;
import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import com.prowidesoftware.swift.model.SwiftBlock3;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftBlock5;
import com.prowidesoftware.swift.model.SwiftBlockUser;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.UnparsedTextList;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.model.mt.AckSystemMessage;
import com.prowidesoftware.swift.model.mt.MTVariant;
import com.prowidesoftware.swift.model.mt.MtCategory;
import com.prowidesoftware.swift.model.mt.ServiceIdType;
import com.prowidesoftware.swift.utils.IMessageVisitor;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SwiftMessage
implements Serializable {
    private static final long serialVersionUID = 8094995269559985432L;
    private static final transient Logger log = Logger.getLogger(SwiftMessage.class.getName());
    private static final int JSON_VERSION = 1;
    private SwiftBlock1 block1;
    private SwiftBlock2 block2;
    private SwiftBlock3 block3;
    private SwiftBlock4 block4;
    private SwiftBlock5 block5;
    private SequenceNode parsedSequences;
    private List<SwiftBlockUser> userBlocks;
    private UnparsedTextList unparsedTexts = null;
    protected Long id;

    public SwiftMessage() {
    }

    public SwiftMessage(boolean initBlocks) {
        if (initBlocks) {
            this.addBlock(new SwiftBlock1());
            this.addBlock(new SwiftBlock2Input());
            this.addBlock(new SwiftBlock3());
            this.addBlock(new SwiftBlock4());
            this.addBlock(new SwiftBlock5());
            this.userBlocks = new ArrayList<SwiftBlockUser>();
        }
    }

    public SwiftMessage(boolean initBlocks, UnparsedTextList unparsedText) {
        this(initBlocks);
        this.unparsedTexts = unparsedText;
    }

    public SwiftMessage(UnparsedTextList unparsedText) {
        this();
        this.unparsedTexts = unparsedText;
    }

    public static final SwiftMessage parse(String fin) throws IOException {
        return new SwiftParser(fin).message();
    }

    public SwiftBlock getBlock(int b) {
        Validate.isTrue((1 <= b && b <= 5 ? 1 : 0) != 0, (String)("block index must be 1-5 (was " + b + ")"));
        switch (b) {
            case 1: {
                return this.block1;
            }
            case 2: {
                return this.block2;
            }
            case 3: {
                return this.block3;
            }
            case 4: {
                return this.block4;
            }
            case 5: {
                return this.block5;
            }
        }
        log.severe("Invalid block number " + b + ". Expected numbers are 1 to 5");
        return null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void addBlock(SwiftBlock b) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Add block " + b);
        }
        Validate.notNull((Object)b);
        if (b instanceof SwiftBlockUser) {
            this.addUserBlock((SwiftBlockUser)b);
        } else {
            Validate.notNull((Object)b.getNumber(), (String)"SwiftBlock.getNumber() is null");
            int index = b.getNumber();
            Validate.isTrue((index >= 1 && index <= 5 ? 1 : 0) != 0, (String)"SwiftBlock.getNumber int did not return an int between 1-5");
            switch (index) {
                case 1: {
                    this.setBlock1((SwiftBlock1)b);
                    break;
                }
                case 2: {
                    this.setBlock2((SwiftBlock2)b);
                    break;
                }
                case 3: {
                    this.setBlock3((SwiftBlock3)b);
                    break;
                }
                case 4: {
                    this.setBlock4((SwiftBlock4)b);
                    break;
                }
                case 5: {
                    this.setBlock5((SwiftBlock5)b);
                    break;
                }
                default: {
                    log.severe("Invalid block number " + b + ". Expected numbers are 1 to 5");
                }
            }
        }
    }

    @Deprecated
    public boolean isMT(String type) {
        Validate.notNull((Object)type);
        Validate.isTrue((type.length() == 3 ? 1 : 0) != 0, (String)("The string must be exactly 3 chars size (type=" + type + ")"));
        return this.getType() != null && this.getType().equals(type);
    }

    public String getType() {
        if (this.getBlock2() != null) {
            return this.getBlock2().getMessageType();
        }
        return null;
    }

    public void visit(IMessageVisitor visitor) {
        SwiftBlock5 b5;
        SwiftBlock4 b4;
        SwiftBlock3 b3;
        SwiftBlock2 b2;
        Validate.notNull((Object)visitor);
        visitor.startMessage(this);
        SwiftBlock1 b1 = this.getBlock1();
        if (b1 != null) {
            visitor.startBlock1(b1);
            visitor.value(b1, b1.getValue());
            visitor.endBlock1(b1);
        }
        if ((b2 = this.getBlock2()) != null) {
            visitor.startBlock2(b2);
            visitor.value(b2, b2.getValue());
            visitor.endBlock2(b2);
        }
        if ((b3 = this.getBlock3()) != null) {
            visitor.startBlock3(b3);
            SwiftMessage.visit(b3, visitor);
            visitor.endBlock3(b3);
        }
        if ((b4 = this.getBlock4()) != null) {
            visitor.startBlock4(b4);
            SwiftMessage.visit(b4, visitor);
            visitor.endBlock4(b4);
        }
        if ((b5 = this.getBlock5()) != null) {
            visitor.startBlock5(b5);
            SwiftMessage.visit(b5, visitor);
            visitor.endBlock5(b5);
        }
        if (this.userBlocks != null) {
            for (int i = 0; i < this.userBlocks.size(); ++i) {
                SwiftBlockUser userBlock = this.userBlocks.get(i);
                if (userBlock == null) continue;
                visitor.startBlockUser(userBlock);
                SwiftMessage.visit(userBlock, visitor);
                visitor.endBlockUser(userBlock);
            }
        }
        visitor.endMessage(this);
    }

    public static void visit(SwiftBlock3 block, IMessageVisitor visitor) {
        Validate.notNull((Object)block);
        Validate.notNull((Object)visitor);
        Iterator<Tag> it = block.tagIterator();
        while (it.hasNext()) {
            visitor.tag(block, it.next());
        }
    }

    public static void visit(SwiftBlock4 block, IMessageVisitor visitor) {
        Validate.notNull((Object)block);
        Validate.notNull((Object)visitor);
        Iterator<Tag> it = block.tagIterator();
        while (it.hasNext()) {
            Tag t = it.next();
            visitor.tag(block, t);
        }
    }

    public static void visit(SwiftBlock5 block, IMessageVisitor visitor) {
        Validate.notNull((Object)block);
        Validate.notNull((Object)visitor);
        Iterator<Tag> it = block.tagIterator();
        while (it.hasNext()) {
            Tag t = it.next();
            visitor.tag(block, t);
        }
    }

    public static void visit(SwiftBlockUser block, IMessageVisitor visitor) {
        Validate.notNull((Object)block);
        Validate.notNull((Object)visitor);
        Iterator<Tag> it = block.tagIterator();
        while (it.hasNext()) {
            Tag t = it.next();
            visitor.tag(block, t);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getBlockCount() {
        return this.getBlockCount(Boolean.TRUE);
    }

    public int getBlockCount(Boolean includeUserBlocks) {
        int count = 0;
        if (this.block1 != null && !this.getBlock1().isEmpty()) {
            ++count;
        }
        if (this.block2 != null && !this.getBlock2().isEmpty()) {
            ++count;
        }
        if (this.block3 != null && !this.getBlock3().isEmpty()) {
            ++count;
        }
        if (this.block4 != null && !this.getBlock4().isEmpty()) {
            ++count;
        }
        if (this.block5 != null && !this.getBlock5().isEmpty()) {
            ++count;
        }
        if (includeUserBlocks.booleanValue() && this.userBlocks != null) {
            count += this.userBlocks.size();
        }
        return count;
    }

    public SwiftBlock1 getBlock1() {
        return this.block1;
    }

    public void setBlock1(SwiftBlock1 block1) {
        this.block1 = block1;
    }

    public SwiftBlock2 getBlock2() {
        return this.block2;
    }

    public void setBlock2(SwiftBlock2 block2) {
        this.block2 = block2;
    }

    public SwiftBlock3 getBlock3() {
        return this.block3;
    }

    public void setBlock3(SwiftBlock3 block3) {
        this.block3 = block3;
    }

    public SwiftBlock4 getBlock4() {
        return this.block4;
    }

    public void setBlock4(SwiftBlock4 block4) {
        this.block4 = block4;
    }

    public SwiftBlock5 getBlock5() {
        return this.block5;
    }

    public void setBlock5(SwiftBlock5 block5) {
        this.block5 = block5;
    }

    public int getUserBlockPosition(String blockName) {
        if (StringUtils.isBlank((String)blockName) || this.userBlocks == null) {
            return -1;
        }
        for (int i = 0; i < this.userBlocks.size(); ++i) {
            SwiftBlockUser userBlock = this.userBlocks.get(i);
            if (userBlock == null || !StringUtils.equals((String)userBlock.getName(), (String)blockName)) continue;
            return i;
        }
        return -1;
    }

    public List<SwiftBlockUser> getUserBlocks() {
        return this.userBlocks;
    }

    protected void setUserBlocks(List<SwiftBlockUser> userBlocks) {
        Validate.notNull(userBlocks, (String)"parameter 'userBlocks' cannot be null");
        Validate.allElementsOfType(userBlocks, SwiftBlockUser.class, (String)"parameter 'userBlocks' may only have SwiftBlockUser elements");
        this.userBlocks = userBlocks;
    }

    public SwiftBlockUser getUserBlock(String blockName) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null");
        int pos = this.getUserBlockPosition(blockName);
        if (pos != -1) {
            return this.userBlocks.get(pos);
        }
        return null;
    }

    public SwiftBlockUser getUserBlock(Integer blockNumber) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null");
        return this.getUserBlock(blockNumber.toString());
    }

    public void addUserBlock(SwiftBlockUser userBlock) {
        int pos;
        Validate.notNull((Object)userBlock);
        Validate.isTrue((boolean)userBlock.isValidName(), (String)("Invalid name for User Defined Blocks (" + userBlock.getName() + ")"));
        if (this.userBlocks == null) {
            this.userBlocks = new ArrayList<SwiftBlockUser>();
        }
        if ((pos = this.getUserBlockPosition(userBlock.getName())) != -1) {
            this.userBlocks.add(pos, userBlock);
        } else {
            this.userBlocks.add(userBlock);
        }
    }

    public void removeUserBlock(Integer blockNumber) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockNumber), (String)("Invalid name for User Defined Blocks (" + blockNumber.toString() + ")"));
        this.removeUserBlock(blockNumber.toString());
    }

    public void removeUserBlock(String blockName) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockName), (String)("Invalid name for User Defined Blocks (" + blockName + ")"));
        int pos = this.getUserBlockPosition(blockName);
        if (pos != -1) {
            this.userBlocks.remove(pos);
        }
    }

    public void clear() {
        this.block1 = null;
        this.block2 = null;
        this.block3 = null;
        this.block4 = null;
        this.block5 = null;
        this.userBlocks = null;
    }

    public Boolean isFragment() {
        SwiftBlock4 b4 = this.getBlock4();
        if (b4 != null) {
            String t202 = b4.getTagValue("202");
            String t203 = b4.getTagValue("203");
            return t202 != null && t203 != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLastFragment() {
        if (!this.isFragment().booleanValue()) {
            return Boolean.FALSE;
        }
        Integer count = this.fragmentCount();
        try {
            Integer number = this.fragmentNumber();
            return count.intValue() == number.intValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalStateException("Invalid call to islastFragment for a non fragmented message", e);
        }
    }

    public Integer fragmentCount() {
        Integer _t203;
        if (!this.isFragment().booleanValue()) {
            return new Integer(0);
        }
        SwiftBlock4 b4 = this.getBlock4();
        String t203 = b4.getTagValue("203");
        try {
            _t203 = new Integer(Integer.parseInt(t203, 10));
        }
        catch (NumberFormatException nfe) {
            throw new UnsupportedOperationException("message is not a fragment");
        }
        return _t203;
    }

    public Integer fragmentNumber() {
        Integer _t202;
        if (!this.isFragment().booleanValue()) {
            throw new UnsupportedOperationException("message is not a fragment");
        }
        SwiftBlock4 b4 = this.getBlock4();
        String t202 = b4.getTagValue("202");
        try {
            _t202 = new Integer(Integer.parseInt(t202, 10));
        }
        catch (NumberFormatException nfe) {
            throw new UnsupportedOperationException("message is not a fragment");
        }
        return _t202;
    }

    protected void unparsedTextVerify() {
        if (this.unparsedTexts == null) {
            this.unparsedTexts = new UnparsedTextList();
        }
    }

    public UnparsedTextList getUnparsedTexts() {
        this.unparsedTextVerify();
        return this.unparsedTexts;
    }

    public void setUnparsedTexts(UnparsedTextList texts) {
        this.unparsedTexts = texts;
    }

    public Integer getUnparsedTextsSize() {
        if (this.unparsedTexts == null) {
            return new Integer(0);
        }
        return this.unparsedTexts.size();
    }

    public Boolean unparsedTextIsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.isMessage(index);
    }

    public String unparsedTextGetText(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getText(index);
    }

    public SwiftMessage unparsedTextGetAsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getTextAsMessage(index);
    }

    public void unparsedTextAddText(String text) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(text);
    }

    public void unparsedTextAddText(SwiftMessage message) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(message);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.block1 == null ? 0 : this.block1.hashCode());
        result = 31 * result + (this.block2 == null ? 0 : this.block2.hashCode());
        result = 31 * result + (this.block3 == null ? 0 : this.block3.hashCode());
        result = 31 * result + (this.block4 == null ? 0 : this.block4.hashCode());
        result = 31 * result + (this.block5 == null ? 0 : this.block5.hashCode());
        result = 31 * result + (this.unparsedTexts == null ? 0 : this.unparsedTexts.hashCode());
        result = 31 * result + (this.userBlocks == null ? 0 : ((Object)this.userBlocks).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwiftMessage other = (SwiftMessage)obj;
        if (this.block1 == null ? other.block1 != null : !this.block1.equals(other.block1)) {
            return false;
        }
        if (this.block2 == null ? other.block2 != null : !this.block2.equals(other.block2)) {
            return false;
        }
        if (this.block3 == null ? other.block3 != null : !this.block3.equals(other.block3)) {
            return false;
        }
        if (this.block4 == null ? other.block4 != null : !this.block4.equals(other.block4)) {
            return false;
        }
        if (this.block5 == null ? other.block5 != null : !this.block5.equals(other.block5)) {
            return false;
        }
        if (this.unparsedTexts == null ? other.unparsedTexts != null : !this.unparsedTexts.equals(other.unparsedTexts)) {
            return false;
        }
        return !(this.userBlocks == null ? other.userBlocks != null : !((Object)this.userBlocks).equals(other.userBlocks));
    }

    public boolean isCOV() {
        if (this.block3 != null) {
            return this.block3.containsTag(new Tag("119", "COV"));
        }
        return false;
    }

    public boolean isSTP() {
        if (this.block3 != null) {
            return this.block3.containsTag(new Tag("119", "STP"));
        }
        return false;
    }

    public boolean isREMIT() {
        if (this.block3 != null) {
            return this.block3.containsTag(new Tag("119", "REMIT"));
        }
        return false;
    }

    public String getSender() {
        try {
            if (this.isServiceMessage() || this.getDirection() == MessageIOType.outgoing) {
                return this.getBlock1() == null ? null : this.getBlock1().getLogicalTerminal();
            }
            if (this.getDirection() == MessageIOType.incoming && this.getBlock2() != null) {
                return ((SwiftBlock2Output)this.getBlock2()).getMIRLogicalTerminal();
            }
        }
        catch (Exception e) {
            log.severe("Exception ocurred while retrieving sender's BIC from message data: " + e);
        }
        return null;
    }

    public String getReceiver() {
        try {
            if (this.isServiceMessage()) {
                return null;
            }
            if (this.getDirection() == MessageIOType.incoming) {
                return this.getBlock1().getLogicalTerminal();
            }
            if (this.getDirection() == MessageIOType.outgoing) {
                return ((SwiftBlock2Input)this.getBlock2()).getReceiverAddress();
            }
            return null;
        }
        catch (Exception e) {
            log.severe("Exception ocurred while retrieving receiver's BIC from message data: " + e);
            return null;
        }
    }

    public List<Field> fields(String ... names) {
        Validate.notNull((Object)names, (String)"names is null");
        ArrayList<Field> result = new ArrayList<Field>();
        for (String n : names) {
            Tag[] tl = this.getBlock4().getTagsByName(n);
            if (tl == null || tl.length <= 0) continue;
            for (Tag t : tl) {
                result.add(t.getField());
            }
        }
        return result;
    }

    public void removeEmptyBlocks() {
        if (this.block1 != null && this.getBlock1().isEmpty()) {
            this.block1 = null;
        }
        if (this.block2 != null && this.getBlock2().isEmpty()) {
            this.block2 = null;
        }
        if (this.block3 != null && this.getBlock3().isEmpty()) {
            this.block3 = null;
        }
        if (this.block4 != null && this.getBlock4().isEmpty()) {
            this.block4 = null;
        }
        if (this.block5 != null && this.getBlock5().isEmpty()) {
            this.block5 = null;
        }
    }

    public int getTypeInt() {
        if (this.isServiceMessage()) {
            return -1;
        }
        try {
            return Integer.valueOf(this.getType());
        }
        catch (NumberFormatException e) {
            String text = "Error converting type to int " + this.getType();
            log.warning(text);
            log.log(Level.FINEST, text, e);
            return -1;
        }
    }

    public MessageIOType getDirection() {
        try {
            if (this.block2 == null) {
                log.info("Requesting direction on a message without block2, can't determine direction. set log level to finer to view more details");
                log.finest("Message: " + this);
            } else {
                if (this.block2.isOutput()) {
                    return MessageIOType.incoming;
                }
                if (this.block2.isInput()) {
                    return MessageIOType.outgoing;
                }
            }
        }
        catch (Exception e) {
            log.severe("Unexpected exception ocurred while determining direction from message data: " + e);
        }
        return null;
    }

    public boolean isOutgoing() {
        return this.getDirection() == MessageIOType.outgoing;
    }

    public boolean isInput() {
        return this.isOutgoing();
    }

    public boolean isIncoming() {
        return this.getDirection() == MessageIOType.incoming;
    }

    public boolean isOutput() {
        return this.isIncoming();
    }

    public String getPDE() {
        return this.getBlock5() != null ? this.getBlock5().getTagValue("PDE") : null;
    }

    public String getPDM() {
        return this.getBlock5() != null ? this.getBlock5().getTagValue("PDM") : null;
    }

    public String getMIR() {
        if (this.getBlock2() != null && this.getBlock2().isOutput()) {
            SwiftBlock2Output b2 = (SwiftBlock2Output)this.getBlock2();
            return b2.getMIR();
        }
        return null;
    }

    public String getMUR() {
        return this.getBlock3() != null ? this.getBlock3().getTagValue("108") : null;
    }

    public String getUUID() {
        return null;
    }

    public SequenceNode getParsedSequences() {
        return this.parsedSequences;
    }

    public void setParsedSequences(SequenceNode parsedSequences) {
        this.parsedSequences = parsedSequences;
    }

    public Field field(String name) {
        List<Field> l = this.fields(name);
        if (l.size() == 0) {
            return null;
        }
        return l.get(0);
    }

    public Boolean isLinked() {
        SwiftBlock4 b4 = this.getBlock4();
        if (b4 != null) {
            return !b4.getSubBlock("LINK").isEmpty();
        }
        return null;
    }

    public List<SwiftTagListBlock> getLinkages() {
        SwiftBlock4 b4 = this.getBlock4();
        if (b4 != null) {
            return b4.getSubBlocks("LINK");
        }
        return null;
    }

    public String toJson() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String ts = dateFormat.format(Calendar.getInstance().getTime());
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"version\" : ").append(1).append(",\n");
        sb.append(" \"timestamp\" : \"").append(ts).append("\",\n");
        sb.append(" \"data\" : { \n");
        sb.append("\"block1\" : \n");
        if (this.block1 == null) {
            sb.append(" {}");
        } else {
            sb.append(this.block1.toJson());
        }
        sb.append(",\n");
        sb.append("\"block2\" : \n");
        if (this.block2 == null) {
            sb.append(" {}");
        } else {
            sb.append(this.block2.toJson());
        }
        sb.append(",\n");
        this.appendBlock("3", sb, this.block3);
        sb.append(',');
        this.appendBlock("4", sb, this.block4);
        sb.append(',');
        this.appendBlock("5", sb, this.block5);
        if (this.userBlocks != null && !this.userBlocks.isEmpty()) {
            Iterator<SwiftBlockUser> ubit = this.userBlocks.iterator();
            sb.append(',');
            sb.append("\"userblocks\" : [ \n");
            while (ubit.hasNext()) {
                SwiftBlockUser ub = ubit.next();
                sb.append("{ ");
                sb.append("\"name\" :  \"").append(ub.getName()).append("\",\n \"tags\" : ");
                sb.append(ub.toJson());
                sb.append("}\n");
            }
            sb.append("] \n");
        }
        sb.append("}\n");
        sb.append("}\n");
        return sb.toString();
    }

    public final String toXml() {
        StringWriter w = new StringWriter();
        this.visit(new XMLWriterVisitor(w, true));
        String xml = w.getBuffer().toString();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("xml: " + xml);
        }
        return xml;
    }

    private void appendBlock(String blockName, StringBuilder sb, SwiftTagListBlock b) {
        sb.append("\"block" + blockName + "\" : \n");
        if (b == null) {
            sb.append("{ }");
        } else {
            sb.append(b.toJson());
        }
        sb.append("\n");
    }

    public AbstractMT toMT() {
        String type = this.getType();
        if (type == null) {
            if (this.isServiceMessage21()) {
                return AckSystemMessage.newInstance(this);
            }
            log.warning("Cannot determine the message type from application header (block 2)");
        } else {
            StringBuilder className = new StringBuilder();
            className.append("com.prowidesoftware.swift.model.mt.mt");
            className.append(String.valueOf(type.charAt(0)));
            className.append("xx.MT");
            className.append(type);
            if (this.isSTP()) {
                if (this.isType(102, 103)) {
                    className.append("_STP");
                } else {
                    log.warning("Unexpected STP flag in MT " + this.getType());
                }
            } else if (this.isREMIT()) {
                if (this.isType(103)) {
                    className.append("_REMIT");
                } else {
                    log.warning("Unexpected REMIT flag in MT " + this.getType());
                }
            } else if (this.isCOV()) {
                if (this.isType(202, 205)) {
                    className.append("COV");
                } else {
                    log.warning("Unexpected COV flag in MT " + this.getType());
                }
            }
            log.finer("About to create an instance of " + className);
            try {
                Class<?> mtClass = Class.forName(className.toString());
                return (AbstractMT)mtClass.getConstructor(SwiftMessage.class).newInstance(this);
            }
            catch (Exception e) {
                log.warning("Could not create instance of " + className + ": " + e);
            }
        }
        return null;
    }

    public boolean isType(int type) {
        return this.getTypeInt() == type;
    }

    public boolean isType(int ... types) {
        int mt = this.getTypeInt();
        for (int t : types) {
            if (mt != t) continue;
            return true;
        }
        return false;
    }

    public final boolean isCategory(MtCategory ... categories) {
        MtCategory cat = this.getCategory();
        for (MtCategory t : categories) {
            if (cat != t) continue;
            return true;
        }
        return false;
    }

    public final MtCategory getCategory() {
        String type = this.getType();
        if (type != null) {
            try {
                return MtCategory.valueOf("_" + type.substring(0, 1));
            }
            catch (Exception e) {
                String text = "Error extracting category from message type " + this.getType();
                log.warning(text);
                log.log(Level.FINEST, text, e);
            }
        }
        return null;
    }

    public final boolean isServiceMessage() {
        if (this.getBlock1() == null) {
            return false;
        }
        return this.getBlock1().getServiceIdType() != ServiceIdType._01;
    }

    @Deprecated
    public boolean isSystemMessage() {
        return this.isServiceMessage21();
    }

    public boolean isServiceMessage21() {
        if (this.getBlock1() == null) {
            return false;
        }
        return this.getBlock1().getServiceIdType() == ServiceIdType._21;
    }

    public boolean isAck() {
        if (this.isServiceMessage21()) {
            if (this.getBlock4() == null) {
                return false;
            }
            Tag _451 = this.getBlock4().getTagByNumber(451);
            if (_451 == null) {
                return false;
            }
            return StringUtils.equals((String)_451.getValue(), (String)"0");
        }
        return false;
    }

    public boolean isNack() {
        if (this.isServiceMessage21()) {
            if (this.getBlock4() == null) {
                return false;
            }
            Tag _451 = this.getBlock4().getTagByNumber(451);
            if (_451 == null) {
                return false;
            }
            return StringUtils.equals((String)_451.getValue(), (String)"1");
        }
        return false;
    }

    public MTVariant getVariant() {
        if (this.isCOV()) {
            return MTVariant.COV;
        }
        if (this.isSTP()) {
            return MTVariant.STP;
        }
        if (this.isREMIT()) {
            return MTVariant.REMIT;
        }
        return null;
    }

    public List<String> getTagNames() {
        if (this.getBlock4() == null || this.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Tag t : this.getBlock4().getTags()) {
            if (result.contains(t.getName())) continue;
            result.add(t.getName());
        }
        return result;
    }

    public MtId getMtId() {
        if (this.isServiceMessage()) {
            return null;
        }
        return new MtId(this.getType(), this.getVariant());
    }
}

