/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field130
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "130";
    public static final String F_130 = "130";
    public static final String PARSER_PATTERN = "/S/S$/S/S";
    public static final String COMPONENTS_PATTERN = "NSNS";
    public static final Integer HEADING_CODE = 1;
    public static final Integer HEADING_TEXT = 2;
    public static final Integer HEADING_CODE_2 = 3;
    public static final Integer HEADING_TEXT_2 = 4;

    public Field130() {
        super(4);
    }

    public Field130(String value) {
        super(value);
    }

    public Field130(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"130")) {
            throw new IllegalArgumentException("cannot create field 130 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(4);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            this.setComponent1(SwiftParseUtils.getTokenFirst(lines.get(0), "/", "/"));
            this.setComponent2(SwiftParseUtils.getTokenSecondLast(lines.get(0), "/", "/"));
            if (lines.size() > 1) {
                this.setComponent3(SwiftParseUtils.getTokenFirst(lines.get(1), "/", "/"));
                this.setComponent4(SwiftParseUtils.getTokenSecondLast(lines.get(1), "/", "/"));
            }
        }
    }

    public static Field130 newInstance(Field130 source) {
        Field130 cp = new Field130();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append("/");
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        if (this.getComponent3() != null || this.getComponent4() != null) {
            result.append("\r\n");
        }
        result.append("/");
        this.append(result, 3);
        result.append("/");
        this.append(result, 4);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("130", value);
    }

    public static Tag emptyTag() {
        return new Tag("130", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Number getComponent1AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public String getHeadingCode() {
        return this.getComponent(1);
    }

    public Number getHeadingCodeAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public Field130 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field130 setComponent1(Number component1) {
        if (component1 != null) {
            this.setComponent(1, Integer.toString(component1.intValue()));
        }
        return this;
    }

    public Field130 setHeadingCode(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field130 setHeadingCode(Number component1) {
        this.setComponent1(component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getHeadingText() {
        return this.getComponent(2);
    }

    public Field130 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field130 setHeadingText(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getHeadingCode2() {
        return this.getComponent(3);
    }

    public Number getHeadingCode2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public Field130 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field130 setComponent3(Number component3) {
        if (component3 != null) {
            this.setComponent(3, Integer.toString(component3.intValue()));
        }
        return this;
    }

    public Field130 setHeadingCode2(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field130 setHeadingCode2(Number component3) {
        this.setComponent3(component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    @Deprecated
    public String getComponent4AsString() {
        return this.getComponent(4);
    }

    public String getHeadingText2() {
        return this.getComponent(4);
    }

    public Field130 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field130 setHeadingText2(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "130";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "/2!n/65x$/2!n/65x";
    }

    public static Field130 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("130");
        if (t == null) {
            return null;
        }
        return new Field130(t);
    }

    public static Field130 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field130.get(msg.getBlock4());
    }

    public static List<Field130> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field130.getAll(msg.getBlock4());
    }

    public static List<Field130> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("130");
        if (arr != null && arr.length > 0) {
            ArrayList<Field130> result = new ArrayList<Field130>(arr.length);
            for (Tag f : arr) {
                result.add(new Field130(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field130 cp = Field130.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field130 cp = Field130.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field130 cp = Field130.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        NumberFormat f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 130");
        }
        if (component == 1) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent1AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent3AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Heading Code");
        result.add("Heading Text");
        result.add("Heading Code 2");
        result.add("Heading Text 2");
        return result;
    }
}

