/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.MIR;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field252
extends Field
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "252";
    public static final String F_252 = "252";
    public static final String PARSER_PATTERN = "<MIR><MIR>[<HHMM><HHMM>]";
    public static final String COMPONENTS_PATTERN = "RRHH";
    public static final Integer START_MIR = 1;
    public static final Integer END_MIR = 2;
    public static final Integer START_TIME = 3;
    public static final Integer END_TIME = 4;

    public Field252() {
        super(4);
    }

    public Field252(String value) {
        super(value);
    }

    public Field252(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"252")) {
            throw new IllegalArgumentException("cannot create field 252 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(4);
        if (value != null) {
            if (value.length() >= 28) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)28));
            }
            if (value.length() >= 56) {
                this.setComponent2(StringUtils.substring((String)value, (int)28, (int)56));
            }
            if (value.length() >= 60) {
                this.setComponent3(StringUtils.substring((String)value, (int)56, (int)60));
            }
            if (value.length() > 60) {
                this.setComponent4(StringUtils.substring((String)value, (int)60));
            }
        }
    }

    public static Field252 newInstance(Field252 source) {
        Field252 cp = new Field252();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        this.append(result, 3);
        this.append(result, 4);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("252", value);
    }

    public static Tag emptyTag() {
        return new Tag("252", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public MIR getComponent1AsMIR() {
        return SwiftFormatUtils.getMIR(this.getComponent(1));
    }

    public String getStartMIR() {
        return this.getComponent(1);
    }

    public MIR getStartMIRAsMIR() {
        return SwiftFormatUtils.getMIR(this.getComponent(1));
    }

    public Field252 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field252 setComponent1(MIR component1) {
        this.setComponent(1, SwiftFormatUtils.getMIR(component1));
        return this;
    }

    public Field252 setStartMIR(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field252 setStartMIR(MIR component1) {
        this.setComponent1(component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public MIR getComponent2AsMIR() {
        return SwiftFormatUtils.getMIR(this.getComponent(2));
    }

    public String getEndMIR() {
        return this.getComponent(2);
    }

    public MIR getEndMIRAsMIR() {
        return SwiftFormatUtils.getMIR(this.getComponent(2));
    }

    public Field252 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field252 setComponent2(MIR component2) {
        this.setComponent(2, SwiftFormatUtils.getMIR(component2));
        return this;
    }

    public Field252 setEndMIR(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field252 setEndMIR(MIR component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public String getStartTime() {
        return this.getComponent(3);
    }

    public Calendar getStartTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public Field252 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field252 setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getTime3(component3));
        return this;
    }

    public Field252 setStartTime(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field252 setStartTime(Calendar component3) {
        this.setComponent3(component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(4));
    }

    public String getEndTime() {
        return this.getComponent(4);
    }

    public Calendar getEndTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(4));
    }

    public Field252 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field252 setComponent4(Calendar component4) {
        this.setComponent(4, SwiftFormatUtils.getTime3(component4));
        return this;
    }

    public Field252 setEndTime(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field252 setEndTime(Calendar component4) {
        this.setComponent4(component4);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "252";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return PARSER_PATTERN;
    }

    public static Field252 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("252");
        if (t == null) {
            return null;
        }
        return new Field252(t);
    }

    public static Field252 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field252.get(msg.getBlock4());
    }

    public static List<Field252> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field252.getAll(msg.getBlock4());
    }

    public static List<Field252> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("252");
        if (arr != null && arr.length > 0) {
            ArrayList<Field252> result = new ArrayList<Field252>(arr.length);
            for (Tag f : arr) {
                result.add(new Field252(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        SimpleDateFormat f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 252");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 4) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent4AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Start MIR");
        result.add("End MIR");
        result.add("Start Time");
        result.add("End Time");
        return result;
    }
}

