/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field330
extends Field
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "330";
    public static final String F_330 = "330";
    public static final String PARSER_PATTERN = "4!N6!N6!N6!N6!N1!N";
    public static final String COMPONENTS_PATTERN = "NNNNNN";
    public static final Integer SESSION_NUMBER = 1;
    public static final Integer ISN = 2;
    public static final Integer ISN_NAK = 3;
    public static final Integer OSN = 4;
    public static final Integer OSN_NAK = 5;
    public static final Integer ACK_REPLAY_INDICATOR = 6;

    public Field330() {
        super(6);
    }

    public Field330(String value) {
        super(value);
    }

    public Field330(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"330")) {
            throw new IllegalArgumentException("cannot create field 330 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(6);
        if (value != null) {
            if (value.length() >= 4) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)4));
            }
            if (value.length() >= 10) {
                this.setComponent2(StringUtils.substring((String)value, (int)4, (int)10));
            }
            if (value.length() >= 16) {
                this.setComponent3(StringUtils.substring((String)value, (int)10, (int)16));
            }
            if (value.length() >= 22) {
                this.setComponent4(StringUtils.substring((String)value, (int)16, (int)22));
            }
            if (value.length() >= 28) {
                this.setComponent5(StringUtils.substring((String)value, (int)22, (int)28));
            }
            if (value.length() > 28) {
                this.setComponent6(StringUtils.substring((String)value, (int)28));
            }
        }
    }

    public static Field330 newInstance(Field330 source) {
        Field330 cp = new Field330();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("330", value);
    }

    public static Tag emptyTag() {
        return new Tag("330", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Number getComponent1AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public String getSessionNumber() {
        return this.getComponent(1);
    }

    public Number getSessionNumberAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public Field330 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field330 setComponent1(Number component1) {
        if (component1 != null) {
            this.setComponent(1, Integer.toString(component1.intValue()));
        }
        return this;
    }

    public Field330 setSessionNumber(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field330 setSessionNumber(Number component1) {
        this.setComponent1(component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getISN() {
        return this.getComponent(2);
    }

    public Number getISNAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public Field330 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field330 setComponent2(Number component2) {
        if (component2 != null) {
            this.setComponent(2, Integer.toString(component2.intValue()));
        }
        return this;
    }

    public Field330 setISN(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field330 setISN(Number component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getISNNAK() {
        return this.getComponent(3);
    }

    public Number getISNNAKAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public Field330 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field330 setComponent3(Number component3) {
        if (component3 != null) {
            this.setComponent(3, Integer.toString(component3.intValue()));
        }
        return this;
    }

    public Field330 setISNNAK(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field330 setISNNAK(Number component3) {
        this.setComponent3(component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getOSN() {
        return this.getComponent(4);
    }

    public Number getOSNAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field330 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field330 setComponent4(Number component4) {
        if (component4 != null) {
            this.setComponent(4, Integer.toString(component4.intValue()));
        }
        return this;
    }

    public Field330 setOSN(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field330 setOSN(Number component4) {
        this.setComponent4(component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Number getComponent5AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    public String getOSNNAK() {
        return this.getComponent(5);
    }

    public Number getOSNNAKAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    public Field330 setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field330 setComponent5(Number component5) {
        if (component5 != null) {
            this.setComponent(5, Integer.toString(component5.intValue()));
        }
        return this;
    }

    public Field330 setOSNNAK(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field330 setOSNNAK(Number component5) {
        this.setComponent5(component5);
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public Number getComponent6AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    public String getACKReplayIndicator() {
        return this.getComponent(6);
    }

    public Number getACKReplayIndicatorAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    public Field330 setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field330 setComponent6(Number component6) {
        if (component6 != null) {
            this.setComponent(6, Integer.toString(component6.intValue()));
        }
        return this;
    }

    public Field330 setACKReplayIndicator(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field330 setACKReplayIndicator(Number component6) {
        this.setComponent6(component6);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "330";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "4!n6!n6!n6!n6!n1!n";
    }

    public static Field330 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("330");
        if (t == null) {
            return null;
        }
        return new Field330(t);
    }

    public static Field330 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field330.get(msg.getBlock4());
    }

    public static List<Field330> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field330.getAll(msg.getBlock4());
    }

    public static List<Field330> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("330");
        if (arr != null && arr.length > 0) {
            ArrayList<Field330> result = new ArrayList<Field330>(arr.length);
            for (Tag f : arr) {
                result.add(new Field330(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        NumberFormat f;
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 330");
        }
        if (component == 1) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent1AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 2) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 3) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent3AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 4) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 5) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent5AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 6) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent6AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Session Number");
        result.add("ISN");
        result.add("ISN NAK");
        result.add("OSN");
        result.add("OSN NAK");
        result.add("ACK Replay Indicator");
        return result;
    }
}

