/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field33P
extends Field
implements Serializable,
CurrencyContainer,
DateContainer,
AmountContainer {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "33P";
    public static final String F_33P = "33P";
    public static final String PARSER_PATTERN = "<DATE2>SN";
    public static final String COMPONENTS_PATTERN = "ECN";
    public static final Integer DATE = 1;
    public static final Integer CURRENCY = 2;
    public static final Integer AMOUNT = 3;

    public Field33P() {
        super(3);
    }

    public Field33P(String value) {
        super(value);
    }

    public Field33P(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"33P")) {
            throw new IllegalArgumentException("cannot create field 33P from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(3);
        if (value != null) {
            if (value.length() >= 6) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)6));
            }
            String toparse = StringUtils.substring((String)value, (int)6);
            this.setComponent2(SwiftParseUtils.getAlphaPrefix(toparse));
            this.setComponent3(SwiftParseUtils.getNumericSuffix(toparse));
        }
    }

    public static Field33P newInstance(Field33P source) {
        Field33P cp = new Field33P();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("33P", value);
    }

    public static Tag emptyTag() {
        return new Tag("33P", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent(1);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public Field33P setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field33P setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate2(component1));
        return this;
    }

    public Field33P setDate(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field33P setDate(Calendar component1) {
        this.setComponent1(component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getCurrency() {
        return this.getComponent(2);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public Field33P setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field33P setComponent2(Currency component2) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(component2));
        return this;
    }

    public Field33P setCurrency(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field33P setCurrency(Currency component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getAmount() {
        return this.getComponent(3);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public Field33P setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field33P setComponent3(Number component3) {
        this.setComponent(3, SwiftFormatUtils.getNumber(component3));
        return this;
    }

    public Field33P setAmount(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field33P setAmount(Number component3) {
        this.setComponent3(component3);
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
    }

    @Override
    public List<Currency> currencies() {
        List<String> l = this.currencyStrings();
        if (l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> result = new ArrayList<Currency>();
        for (String s : l) {
            result.add(Currency.getInstance(s));
        }
        return result;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate2(this.getComponent(1)));
        return result;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "33P";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<DATE2><CUR><AMOUNT>15";
    }

    public static Field33P get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("33P");
        if (t == null) {
            return null;
        }
        return new Field33P(t);
    }

    public static Field33P get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field33P.get(msg.getBlock4());
    }

    public static List<Field33P> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field33P.getAll(msg.getBlock4());
    }

    public static List<Field33P> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("33P");
        if (arr != null && arr.length > 0) {
            ArrayList<Field33P> result = new ArrayList<Field33P>(arr.length);
            for (Tag f : arr) {
                result.add(new Field33P(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Format f;
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 33P");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            Number n = this.getComponent3AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        result.add("Currency");
        result.add("Amount");
        return result;
    }
}

