/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field35U
extends Field
implements Serializable,
AmountContainer {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "35U";
    public static final String F_35U = "35U";
    public static final String PARSER_PATTERN = "SN[S]";
    public static final String COMPONENTS_PATTERN = "SNS";
    public static final Integer CURRENCY = 1;
    public static final Integer AMOUNT = 2;
    public static final Integer PERIOD = 3;

    public Field35U() {
        super(3);
    }

    public Field35U(String value) {
        super(value);
    }

    public Field35U(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"35U")) {
            throw new IllegalArgumentException("cannot create field 35U from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        String toparse = this.getComponent1() == null ? value : StringUtils.substringAfter((String)value, (String)this.getComponent1());
        this.setComponent2(SwiftParseUtils.getNumericPrefix(toparse));
        this.setComponent3(SwiftParseUtils.getAlphaSuffix(toparse));
    }

    public static Field35U newInstance(Field35U source) {
        Field35U cp = new Field35U();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        this.append(result, 3);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("35U", value);
    }

    public static Tag emptyTag() {
        return new Tag("35U", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getCurrency() {
        return this.getComponent(1);
    }

    public Field35U setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field35U setCurrency(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getAmount() {
        return this.getComponent(2);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public Field35U setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field35U setComponent2(Number component2) {
        this.setComponent(2, SwiftFormatUtils.getNumber(component2));
        return this;
    }

    public Field35U setAmount(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field35U setAmount(Number component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getPeriod() {
        return this.getComponent(3);
    }

    public Field35U setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field35U setPeriod(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return component == 3;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "35U";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "3!a<AMOUNT>15[1a]";
    }

    public static Field35U get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("35U");
        if (t == null) {
            return null;
        }
        return new Field35U(t);
    }

    public static Field35U get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field35U.get(msg.getBlock4());
    }

    public static List<Field35U> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field35U.getAll(msg.getBlock4());
    }

    public static List<Field35U> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("35U");
        if (arr != null && arr.length > 0) {
            ArrayList<Field35U> result = new ArrayList<Field35U>(arr.length);
            for (Tag f : arr) {
                result.add(new Field35U(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 35U");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            Number n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Currency");
        result.add("Amount");
        result.add("Period");
        return result;
    }
}

