/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field37H
extends Field
implements Serializable,
AmountContainer {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "37H";
    public static final String F_37H = "37H";
    public static final String PARSER_PATTERN = "c[c]N";
    public static final String COMPONENTS_PATTERN = "SSN";
    public static final Integer DC_MARK = 1;
    public static final Integer SIGN = 2;
    public static final Integer RATE = 3;

    public Field37H() {
        super(3);
    }

    public Field37H(String value) {
        super(value);
    }

    public Field37H(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"37H")) {
            throw new IllegalArgumentException("cannot create field 37H from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(3);
        String toparse = SwiftParseUtils.getAlphaPrefix(value);
        if (toparse != null && toparse.length() > 1) {
            this.setComponent1(StringUtils.substring((String)toparse, (int)0, (int)(toparse.length() - 1)));
            this.setComponent2(StringUtils.substring((String)toparse, (int)(toparse.length() - 1)));
        } else {
            this.setComponent1(toparse);
        }
        this.setComponent3(SwiftParseUtils.getNumericSuffix(value));
    }

    public static Field37H newInstance(Field37H source) {
        Field37H cp = new Field37H();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        this.append(result, 3);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("37H", value);
    }

    public static Tag emptyTag() {
        return new Tag("37H", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public Field37H setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field37H setDCMark(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getSign() {
        return this.getComponent(2);
    }

    public Field37H setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field37H setSign(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getRate() {
        return this.getComponent(3);
    }

    public Number getRateAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public Field37H setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field37H setComponent3(Number component3) {
        this.setComponent(3, SwiftFormatUtils.getNumber(component3));
        return this;
    }

    public Field37H setRate(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field37H setRate(Number component3) {
        this.setComponent3(component3);
        return this;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "37H";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<DC>[<N>]<AMOUNT>12";
    }

    public static Field37H get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("37H");
        if (t == null) {
            return null;
        }
        return new Field37H(t);
    }

    public static Field37H get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field37H.get(msg.getBlock4());
    }

    public static List<Field37H> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field37H.getAll(msg.getBlock4());
    }

    public static List<Field37H> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("37H");
        if (arr != null && arr.length > 0) {
            ArrayList<Field37H> result = new ArrayList<Field37H>(arr.length);
            for (Tag f : arr) {
                result.add(new Field37H(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 37H");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            Number n = this.getComponent3AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("D/C Mark");
        result.add("Sign");
        result.add("Rate");
        return result;
    }
}

