/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field54B
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "54B";
    public static final String F_54B = "54B";
    public static final String PARSER_PATTERN = "[[/c][/S]$][S]";
    public static final String COMPONENTS_PATTERN = "SSS";
    public static final Integer DC_MARK = 1;
    public static final Integer ACCOUNT = 2;
    public static final Integer LOCATION = 3;

    public Field54B() {
        super(3);
    }

    public Field54B(String value) {
        super(value);
    }

    public Field54B(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"54B")) {
            throw new IllegalArgumentException("cannot create field 54B from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(3);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (lines.isEmpty()) {
            return;
        }
        if (lines.get(0).startsWith("/")) {
            String dcMark = SwiftParseUtils.getTokenFirst(lines.get(0), "/", "/");
            if (StringUtils.isNotEmpty((String)dcMark) && dcMark.length() == 1) {
                this.setComponent1(dcMark);
                this.setComponent2(SwiftParseUtils.getTokenSecondLast(StringUtils.substring((String)lines.get(0), (int)1), "/"));
            } else {
                this.setComponent2(StringUtils.substring((String)lines.get(0), (int)1));
            }
            if (lines.size() > 1) {
                this.setComponent3(lines.get(1));
            }
        } else {
            this.setComponent3(lines.get(0));
        }
    }

    public static Field54B newInstance(Field54B source) {
        Field54B cp = new Field54B();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        if (this.getComponent1() != null) {
            result.append("/").append(this.getComponent1());
        }
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        if (this.getComponent3() != null) {
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(this.getComponent3());
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("54B", value);
    }

    public static Tag emptyTag() {
        return new Tag("54B", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public Field54B setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field54B setDCMark(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getAccount() {
        String c = this.getComponent(2);
        if (c != null) {
            for (int i = 0; i < c.length(); ++i) {
                if (c.charAt(i) == '/') continue;
                return c.substring(i);
            }
            return "";
        }
        return null;
    }

    public Field54B setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field54B setAccount(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getLocation() {
        return this.getComponent(3);
    }

    public Field54B setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field54B setLocation(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 1) {
            return true;
        }
        if (component == 2) {
            return true;
        }
        return component == 3;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "54B";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "[[/<DC>][/34x]$][35x](****)";
    }

    public static Field54B get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("54B");
        if (t == null) {
            return null;
        }
        return new Field54B(t);
    }

    public static Field54B get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field54B.get(msg.getBlock4());
    }

    public static List<Field54B> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field54B.getAll(msg.getBlock4());
    }

    public static List<Field54B> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("54B");
        if (arr != null && arr.length > 0) {
            ArrayList<Field54B> result = new ArrayList<Field54B>(arr.length);
            for (Tag f : arr) {
                result.add(new Field54B(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field54B cp = Field54B.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field54B cp = Field54B.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field54B cp = Field54B.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 54B");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("D/C Mark");
        result.add("Account");
        result.add("Location");
        return result;
    }

    @Deprecated
    public String getDC() {
        return this.getDCMark();
    }

    @Deprecated
    public void setDC(String DC) {
        this.setDCMark(DC);
    }

    @Override
    public String getValueDisplay() {
        return Field54B.formatAccount(this.getComponent2());
    }
}

