/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field90F
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer,
GenericField {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "90F";
    public static final String F_90F = "90F";
    public static final String PARSER_PATTERN = ":S//S/SN/S/N";
    public static final String COMPONENTS_PATTERN = "SSCNSN";
    public static final Integer QUALIFIER = 1;
    public static final Integer AMOUNT_TYPE_CODE = 2;
    public static final Integer CURRENCY = 3;
    public static final Integer AMOUNT = 4;
    public static final Integer QUANTITY_TYPE_CODE = 5;
    public static final Integer QUANTITY = 6;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field90F() {
        super(6);
    }

    public Field90F(String value) {
        super(value);
    }

    public Field90F(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"90F")) {
            throw new IllegalArgumentException("cannot create field 90F from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(6);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        String toparse2 = SwiftParseUtils.getTokenSecondLast(toparse, "/");
        String toparse3 = SwiftParseUtils.getTokenFirst(toparse2, "/");
        this.setComponent3(SwiftParseUtils.getAlphaPrefix(toparse3));
        this.setComponent4(SwiftParseUtils.getNumericSuffix(toparse3));
        String toparse4 = SwiftParseUtils.getTokenSecondLast(toparse2, "/");
        this.setComponent5(SwiftParseUtils.getTokenFirst(toparse4, "/"));
        this.setComponent6(SwiftParseUtils.getTokenSecondLast(toparse4, "/"));
    }

    public static Field90F newInstance(Field90F source) {
        Field90F cp = new Field90F();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        this.append(result, 4);
        result.append("/");
        this.append(result, 5);
        result.append("/");
        this.append(result, 6);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("90F", value);
    }

    public static Tag emptyTag() {
        return new Tag("90F", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field90F setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field90F setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getAmountTypeCode() {
        return this.getComponent(2);
    }

    public Field90F setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field90F setAmountTypeCode(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Currency getComponent3AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public String getCurrency() {
        return this.getComponent(3);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public Field90F setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field90F setComponent3(Currency component3) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(component3));
        return this;
    }

    public Field90F setCurrency(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field90F setCurrency(Currency component3) {
        this.setComponent3(component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getAmount() {
        return this.getComponent(4);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field90F setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field90F setComponent4(Number component4) {
        this.setComponent(4, SwiftFormatUtils.getNumber(component4));
        return this;
    }

    public Field90F setAmount(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field90F setAmount(Number component4) {
        this.setComponent4(component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public String getQuantityTypeCode() {
        return this.getComponent(5);
    }

    public Field90F setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field90F setQuantityTypeCode(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public Number getComponent6AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    public String getQuantity() {
        return this.getComponent(6);
    }

    public Number getQuantityAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    public Field90F setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field90F setComponent6(Number component6) {
        this.setComponent(6, SwiftFormatUtils.getNumber(component6));
        return this;
    }

    public Field90F setQuantity(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field90F setQuantity(Number component6) {
        this.setComponent6(component6);
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
    }

    @Override
    public List<Currency> currencies() {
        List<String> l = this.currencyStrings();
        if (l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> result = new ArrayList<Currency>();
        for (String s : l) {
            result.add(Currency.getInstance(s));
        }
        return result;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "90F";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//4!c/<CUR><AMOUNT>15/4!c/<AMOUNT>15";
    }

    public static Field90F get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("90F");
        if (t == null) {
            return null;
        }
        return new Field90F(t);
    }

    public static Field90F get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field90F.get(msg.getBlock4());
    }

    public static List<Field90F> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field90F.getAll(msg.getBlock4());
    }

    public static List<Field90F> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("90F");
        if (arr != null && arr.length > 0) {
            ArrayList<Field90F> result = new ArrayList<Field90F>(arr.length);
            for (Tag f : arr) {
                result.add(new Field90F(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        NumberFormat f;
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 90F");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent6AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Amount Type Code");
        result.add("Currency");
        result.add("Amount");
        result.add("Quantity Type Code");
        result.add("Quantity");
        return result;
    }
}

