/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field106;
import com.prowidesoftware.swift.model.field.Field107;
import com.prowidesoftware.swift.model.field.Field108;
import com.prowidesoftware.swift.model.field.Field175;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT011
extends AbstractMT
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT011.class.getName());
    public static final String NAME = "011";

    public MT011(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT011(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT011 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT011(m.message());
    }

    public MT011() {
        this("TESTUS00", "TESTUS00");
    }

    public MT011(String sender, String receiver) {
        super(11, sender, receiver);
    }

    @Deprecated
    public MT011(int messageType, String sender, String receiver) {
        super(11, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT011(int, String, String)", "Use the constructor MT011(sender, receiver) instead.");
    }

    public MT011(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT011.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT011 object from FIN content with a Service Message. Check if the MT011 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT011 object from FIN content with message type " + param.getType());
        }
    }

    public static MT011 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT011(fin);
    }

    public MT011(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT011 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT011(stream);
    }

    public MT011(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT011 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT011(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT011 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT011 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT011 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field106 getField106() {
        Tag t = this.tag("106");
        if (t != null) {
            return new Field106(t.getValue());
        }
        return null;
    }

    public Field108 getField108() {
        Tag t = this.tag("108");
        if (t != null) {
            return new Field108(t.getValue());
        }
        return null;
    }

    public Field107 getField107() {
        Tag t = this.tag("107");
        if (t != null) {
            return new Field107(t.getValue());
        }
        return null;
    }

    public List<Field175> getField175() {
        ArrayList<Field175> result = new ArrayList<Field175>();
        Tag[] tags = this.tags("175");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field175(tags[i].getValue()));
        }
        return result;
    }
}

