/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt4xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field21A;
import com.prowidesoftware.swift.model.field.Field21C;
import com.prowidesoftware.swift.model.field.Field23E;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field32K;
import com.prowidesoftware.swift.model.field.Field50D;
import com.prowidesoftware.swift.model.field.Field51A;
import com.prowidesoftware.swift.model.field.Field53A;
import com.prowidesoftware.swift.model.field.Field53B;
import com.prowidesoftware.swift.model.field.Field59;
import com.prowidesoftware.swift.model.field.Field71F;
import com.prowidesoftware.swift.model.field.Field77A;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT416
extends AbstractMT
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT416.class.getName());
    public static final String NAME = "416";
    @Deprecated
    public static final String AMAM = "AMAM";
    @Deprecated
    public static final String AMTL = "AMTL";
    @Deprecated
    public static final String AUTH = "AUTH";
    @Deprecated
    public static final String CHQB = "CHQB";
    @Deprecated
    public static final String CLOS = "CLOS";
    @Deprecated
    public static final String CMSW = "CMSW";
    @Deprecated
    public static final String CMTO = "CMTO";
    @Deprecated
    public static final String CMZB = "CMZB";
    @Deprecated
    public static final String COLN = "COLN";
    @Deprecated
    public static final String CORT = "CORT";
    @Deprecated
    public static final String DRAW = "DRAW";
    @Deprecated
    public static final String DUPL = "DUPL";
    @Deprecated
    public static final String EQUI = "EQUI";
    @Deprecated
    public static final String FRAU = "FRAU";
    @Deprecated
    public static final String FROZ = "FROZ";
    @Deprecated
    public static final String FRWD = "FRWD";
    @Deprecated
    public static final String HOLD = "HOLD";
    @Deprecated
    public static final String INCH = "INCH";
    @Deprecated
    public static final String INSF = "INSF";
    @Deprecated
    public static final String INSI = "INSI";
    @Deprecated
    public static final String INTC = "INTC";
    @Deprecated
    public static final String INVA = "INVA";
    @Deprecated
    public static final String NACC = "NACC";
    @Deprecated
    public static final String NAUT = "NAUT";
    @Deprecated
    public static final String NELI = "NELI";
    @Deprecated
    public static final String NETS = "NETS";
    @Deprecated
    public static final String NMAT = "NMAT";
    @Deprecated
    public static final String NPAY = "NPAY";
    @Deprecated
    public static final String OTHR = "OTHR";
    @Deprecated
    public static final String PHOB = "PHOB";
    @Deprecated
    public static final String PHOI = "PHOI";
    @Deprecated
    public static final String PHON = "PHON";
    @Deprecated
    public static final String REPA = "REPA";
    @Deprecated
    public static final String REVO = "REVO";
    @Deprecated
    public static final String RFDD = "RFDD";
    @Deprecated
    public static final String RTGS = "RTGS";
    @Deprecated
    public static final String RTND = "RTND";
    @Deprecated
    public static final String SDVA = "SDVA";
    @Deprecated
    public static final String STLD = "STLD";
    @Deprecated
    public static final String STOP = "STOP";
    @Deprecated
    public static final String TELB = "TELB";
    @Deprecated
    public static final String TELE = "TELE";
    @Deprecated
    public static final String TELI = "TELI";
    @Deprecated
    public static final String URGP = "URGP";

    public MT416(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT416(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT416 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT416(m.message());
    }

    public MT416() {
        this("TESTUS00", "TESTUS00");
    }

    public MT416(String sender, String receiver) {
        super(416, sender, receiver);
    }

    @Deprecated
    public MT416(int messageType, String sender, String receiver) {
        super(416, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT416(int, String, String)", "Use the constructor MT416(sender, receiver) instead.");
    }

    public MT416(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT416.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT416 object from FIN content with a Service Message. Check if the MT416 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT416 object from FIN content with message type " + param.getType());
        }
    }

    public static MT416 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT416(fin);
    }

    public MT416(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT416 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT416(stream);
    }

    public MT416(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT416 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT416(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT416 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT416 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT416 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field51A getField51A() {
        Tag t = this.tag("51A");
        if (t != null) {
            return new Field51A(t.getValue());
        }
        return null;
    }

    public Field53A getField53A() {
        Tag t = this.tag("53A");
        if (t != null) {
            return new Field53A(t.getValue());
        }
        return null;
    }

    public Field53B getField53B() {
        Tag t = this.tag("53B");
        if (t != null) {
            return new Field53B(t.getValue());
        }
        return null;
    }

    public List<Field21A> getField21A() {
        ArrayList<Field21A> result = new ArrayList<Field21A>();
        Tag[] tags = this.tags("21A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field21A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field23E> getField23E() {
        ArrayList<Field23E> result = new ArrayList<Field23E>();
        Tag[] tags = this.tags("23E");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field23E(tags[i].getValue()));
        }
        return result;
    }

    public List<Field21C> getField21C() {
        ArrayList<Field21C> result = new ArrayList<Field21C>();
        Tag[] tags = this.tags("21C");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field21C(tags[i].getValue()));
        }
        return result;
    }

    public List<Field32A> getField32A() {
        ArrayList<Field32A> result = new ArrayList<Field32A>();
        Tag[] tags = this.tags("32A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field32A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field32B> getField32B() {
        ArrayList<Field32B> result = new ArrayList<Field32B>();
        Tag[] tags = this.tags("32B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field32B(tags[i].getValue()));
        }
        return result;
    }

    public List<Field32K> getField32K() {
        ArrayList<Field32K> result = new ArrayList<Field32K>();
        Tag[] tags = this.tags("32K");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field32K(tags[i].getValue()));
        }
        return result;
    }

    public List<Field50D> getField50D() {
        ArrayList<Field50D> result = new ArrayList<Field50D>();
        Tag[] tags = this.tags("50D");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field50D(tags[i].getValue()));
        }
        return result;
    }

    public List<Field59> getField59() {
        ArrayList<Field59> result = new ArrayList<Field59>();
        Tag[] tags = this.tags("59");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field59(tags[i].getValue()));
        }
        return result;
    }

    public List<Field71F> getField71F() {
        ArrayList<Field71F> result = new ArrayList<Field71F>();
        Tag[] tags = this.tags("71F");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field71F(tags[i].getValue()));
        }
        return result;
    }

    public List<Field77A> getField77A() {
        ArrayList<Field77A> result = new ArrayList<Field77A>();
        Tag[] tags = this.tags("77A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field77A(tags[i].getValue()));
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return this.getSequenceA(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            SwiftTagListBlock content = parentSequence.getSubBlockDelimitedWithOptionalTail(SequenceA.START, SequenceA.END, SequenceA.TAIL);
            if (log.isLoggable(Level.FINE)) {
                if (content == null) {
                    log.fine("content for sequence SequenceA: is null");
                } else {
                    log.fine("content for sequence SequenceA: " + content.tagNamesList());
                }
            }
            if (content == null) {
                return new SequenceA();
            }
            return new SequenceA(content);
        }
        return null;
    }

    public List<SequenceB> getSequenceBList() {
        return MT416.getSequenceBList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceB> getSequenceBList(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            ArrayList<SequenceB> result = new ArrayList<SequenceB>();
            List<SwiftTagListBlock> bs = parentSequence.getSubBlocksDelimitedWithOptionalTail(SequenceB.START, SequenceB.END, SequenceB.TAIL);
            if (bs != null && !bs.isEmpty()) {
                for (SwiftTagListBlock s : bs) {
                    result.add(new SequenceB(s));
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"21A"};
        protected static final String[] END = new String[]{"32A", "32B", "32K"};
        protected static final String[] TAIL = new String[]{"50D", "59", "71F", "77A"};

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            return SequenceB.newInstance(0, 0, tags);
        }

        public static SequenceB newInstance(int start, int end, Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"20"};
        protected static final String[] END = new String[]{"21"};
        protected static final String[] TAIL = new String[]{"23E", "51A", "53A", "53B", "71F", "77A"};

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            return SequenceA.newInstance(0, 0, tags);
        }

        public static SequenceA newInstance(int start, int end, Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

