/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt7xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT732
extends AbstractMT
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT732.class.getName());
    public static final String NAME = "732";

    public MT732(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT732(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT732 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT732(m.message());
    }

    public MT732() {
        this("TESTUS00", "TESTUS00");
    }

    public MT732(String sender, String receiver) {
        super(732, sender, receiver);
    }

    @Deprecated
    public MT732(int messageType, String sender, String receiver) {
        super(732, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT732(int, String, String)", "Use the constructor MT732(sender, receiver) instead.");
    }

    public MT732(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT732.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT732 object from FIN content with a Service Message. Check if the MT732 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT732 object from FIN content with message type " + param.getType());
        }
    }

    public static MT732 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT732(fin);
    }

    public MT732(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT732 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT732(stream);
    }

    public MT732(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT732 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT732(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT732 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT732 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT732 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field32B getField32B() {
        Tag t = this.tag("32B");
        if (t != null) {
            return new Field32B(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }
}

