/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt8xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field19;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field26B;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field51A;
import com.prowidesoftware.swift.model.field.Field51C;
import com.prowidesoftware.swift.model.field.Field68A;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field77B;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT824
extends AbstractMT
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT824.class.getName());
    public static final String NAME = "824";

    public MT824(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT824(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT824 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT824(m.message());
    }

    public MT824() {
        this("TESTUS00", "TESTUS00");
    }

    public MT824(String sender, String receiver) {
        super(824, sender, receiver);
    }

    @Deprecated
    public MT824(int messageType, String sender, String receiver) {
        super(824, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT824(int, String, String)", "Use the constructor MT824(sender, receiver) instead.");
    }

    public MT824(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT824.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT824 object from FIN content with a Service Message. Check if the MT824 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT824 object from FIN content with message type " + param.getType());
        }
    }

    public static MT824 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT824(fin);
    }

    public MT824(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT824 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT824(stream);
    }

    public MT824(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT824 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT824(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT824 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT824 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT824 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field51A getField51A() {
        Tag t = this.tag("51A");
        if (t != null) {
            return new Field51A(t.getValue());
        }
        return null;
    }

    public Field51C getField51C() {
        Tag t = this.tag("51C");
        if (t != null) {
            return new Field51C(t.getValue());
        }
        return null;
    }

    public Field77B getField77B() {
        Tag t = this.tag("77B");
        if (t != null) {
            return new Field77B(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public List<Field68A> getField68A() {
        ArrayList<Field68A> result = new ArrayList<Field68A>();
        Tag[] tags = this.tags("68A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field68A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field26B> getField26B() {
        ArrayList<Field26B> result = new ArrayList<Field26B>();
        Tag[] tags = this.tags("26B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field26B(tags[i].getValue()));
        }
        return result;
    }

    public List<Field19> getField19() {
        ArrayList<Field19> result = new ArrayList<Field19>();
        Tag[] tags = this.tags("19");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field19(tags[i].getValue()));
        }
        return result;
    }
}

