/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io.parser;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.WifeException;
import com.prowidesoftware.swift.io.parser.SwiftParserConfiguration;
import com.prowidesoftware.swift.model.SwiftBlock;
import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import com.prowidesoftware.swift.model.SwiftBlock3;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftBlock5;
import com.prowidesoftware.swift.model.SwiftBlockUser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.UnparsedTextList;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class SwiftParser {
    public static final String EOL = System.getProperty("line.separator", "\n");
    private static final transient Logger log = Logger.getLogger(SwiftParser.class.getName());
    private Reader reader;
    private StringBuilder buffer;
    private SwiftMessage currentMessage;
    private final List errors = new ArrayList();
    private int lastBlockStartOffset = 0;
    private SwiftParserConfiguration configuration = new SwiftParserConfiguration();

    public SwiftParser(InputStream is) {
        this(new InputStreamReader(is));
    }

    public SwiftParser(Reader r) {
        this();
        this.setReader(r);
    }

    public SwiftParser(String message) {
        this(new StringReader(message));
    }

    public SwiftParser() {
    }

    public SwiftParser(File messageFile) throws IOException {
        this(Lib.readFile(messageFile));
    }

    public void setReader(Reader r) {
        this.buffer = new StringBuilder();
        this.reader = r;
    }

    public void setData(String data) {
        this.setReader(new StringReader(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwiftMessage message() throws IOException {
        SwiftMessage message;
        this.currentMessage = message = new SwiftMessage(false);
        this.errors.clear();
        try {
            boolean done = false;
            do {
                SwiftBlock b;
                if ((b = this.consumeBlock(message.getUnparsedTexts())) != null) {
                    this.currentMessage.addBlock(b);
                    continue;
                }
                done = true;
            } while (!done);
        }
        finally {
            this.currentMessage = null;
        }
        return message;
    }

    public SwiftMessage parse(String message) throws IOException {
        this.setData(message);
        return this.message();
    }

    @Deprecated
    protected SwiftBlock consumeBlock() throws IOException {
        DeprecationUtils.phase2(this.getClass(), "consumeBlock()", "Use consumeBlock(UnparsedTextList) instead of this, consumeBlock(null) is acceptable.");
        return this.consumeBlock(null);
    }

    protected SwiftBlock consumeBlock(UnparsedTextList unparsedReceiver) throws IOException {
        SwiftBlock b;
        String unparsed = this.findBlockStart();
        String s = this.readUntilBlockEnds();
        if ("".equals(s)) {
            if (unparsed.length() > 0) {
                if (unparsedReceiver == null) {
                    log.warning("Unparsed text '" + unparsed + "' can not be reported since unparsedReceiver is null");
                } else {
                    unparsedReceiver.addText(unparsed);
                }
            }
            return null;
        }
        if (s.startsWith("1:") && this.currentMessage != null && this.currentMessage.getBlock1() != null) {
            StringBuilder utBuffer = new StringBuilder();
            utBuffer.append("{");
            utBuffer.append(s);
            utBuffer.append("}");
            boolean done = false;
            while (!done) {
                char[] data = new char[128];
                int size = this.reader.read(data);
                if (size > 0) {
                    utBuffer.append(data);
                    continue;
                }
                done = true;
            }
            String unparsedText = utBuffer.toString();
            UnparsedTextList list = this.processUnparsedText(unparsedText);
            if (list != null) {
                this.currentMessage.setUnparsedTexts(list);
            }
            return null;
        }
        char blockId = this.identifyBlock(s);
        if (blockId == ' ') {
            log.severe("unidentified block:" + s);
            throw new WifeException("The block " + s + " could not be identified");
        }
        switch (blockId) {
            case '1': {
                b = new SwiftBlock1(s, this.configuration.isLenient());
                break;
            }
            case '2': {
                if (SwiftParser.isInput(s)) {
                    b = new SwiftBlock2Input(s, this.configuration.isLenient());
                    break;
                }
                b = new SwiftBlock2Output(s, this.configuration.isLenient());
                break;
            }
            case '3': {
                b = this.tagListBlockConsume(new SwiftBlock3(), s);
                break;
            }
            case '4': {
                if (this.configuration.isParseTextBlock()) {
                    if (this.isTextBlock(s)) {
                        b = this.block4Consume(new SwiftBlock4(), s);
                        break;
                    }
                    b = this.tagListBlockConsume(new SwiftBlock4(), s);
                    break;
                }
                b = new SwiftBlock4();
                break;
            }
            case '5': {
                if (this.configuration.isParseTrailerBlock()) {
                    b = this.tagListBlockConsume(new SwiftBlock5(), s);
                    break;
                }
                b = new SwiftBlock5();
                break;
            }
            default: {
                b = this.configuration.isParseUserBlock() ? this.tagListBlockConsume(new SwiftBlockUser(Character.toString(blockId)), s) : new SwiftBlockUser();
            }
        }
        if (unparsed.length() > 0) {
            if (unparsedReceiver == null) {
                log.warning("Unparsed text '" + unparsed + "' can not be reported since unparsedReceiver is null");
            } else {
                unparsedReceiver.addText(unparsed);
            }
        }
        return b;
    }

    private static boolean isInput(String s) {
        int i = s.indexOf(58);
        Character ch = null;
        if (i >= 0 && i + 1 < s.length()) {
            ch = Character.valueOf(s.charAt(i + 1));
        } else if (s.length() > 0) {
            ch = Character.valueOf(s.charAt(0));
        }
        return ch != null && Character.toUpperCase(ch.charValue()) == 'I';
    }

    protected SwiftTagListBlock tagListBlockConsume(SwiftTagListBlock b, String s) throws IOException {
        int start = s.indexOf(58);
        if (start >= 0 && start + 1 < s.length()) {
            String data = s.substring(start + 1);
            for (int i = 0; i < data.length(); ++i) {
                int end;
                char c = data.charAt(i);
                if (c == '{') {
                    end = data.indexOf(125, i);
                    if (end < 0 || data.length() <= end) continue;
                    String inner = data.substring(i + 1, end);
                    i = end;
                    Tag t = new Tag(inner);
                    log.finest("" + t);
                    b.append(t);
                    continue;
                }
                for (end = i; end < data.length() && data.charAt(end) != '{'; ++end) {
                }
                String unparsedText = data.substring(i, end).trim();
                if (!"".equals(unparsedText)) {
                    b.unparsedTextAddText(unparsedText);
                }
                i = end - 1;
            }
        }
        return b;
    }

    protected SwiftBlock4 block4Consume(SwiftBlock4 b, String s) throws IOException {
        int start = 0;
        if (s.charAt(start) == '4') {
            ++start;
        }
        if (s.charAt(start) == ':') {
            ++start;
        }
        boolean isTextBlock = this.isTextBlock(s);
        Tag lastTag = null;
        while (start < s.length()) {
            Tag t;
            String unparsedText;
            int prev;
            int begin = start;
            int c = 32;
            do {
                prev = c;
                c = s.charAt(start++);
            } while (start < s.length() && c != 58 && c != 123 && (prev != 45 || c != 125));
            int ignore = 0;
            if (c == 125 && s.charAt(start - 1) == '-') {
                ignore = 1;
            }
            if (!"".equals(unparsedText = s.substring(begin, start - ignore - 1).trim())) {
                b.unparsedTextAddText(unparsedText);
            }
            if (start == s.length()) continue;
            int end = 0;
            String tag = null;
            String tagUnparsedText = null;
            switch (c) {
                case 125: {
                    if (isTextBlock && ignore == 1 || !isTextBlock) {
                        start = s.length();
                    }
                    log.severe("malformed message: exit by bracket");
                }
                case 58: {
                    end = this.textTagEndBlock4(s, start, isTextBlock);
                    tag = s.substring(start, end);
                    break;
                }
                case 123: {
                    if (s.startsWith("1:", start)) {
                        begin = start > 0 ? start - 1 : 0;
                        end = begin + 1;
                        while (end < s.length() && !s.startsWith("{1:", end)) {
                            end = this.blockTagEnd(s, end + 1);
                        }
                        unparsedText = s.substring(begin, end);
                        b.unparsedTextAddText(unparsedText);
                        break;
                    }
                    end = this.blockTagEnd(s, start);
                    tag = s.substring(start, end - 1);
                    int utPos = tag.indexOf("{1:");
                    if (utPos == -1) break;
                    tagUnparsedText = tag.substring(utPos);
                    tag = tag.substring(0, utPos);
                }
            }
            if (tag != null && (t = this.consumeTag(tag, tagUnparsedText)) != null) {
                b.append(t);
                lastTag = t;
            }
            start = end;
        }
        this.stripEOB(lastTag);
        return b;
    }

    private void stripEOB(Tag lastTag) {
        String v;
        if (lastTag != null && (v = lastTag.getValue()) != null) {
            if (v.endsWith("\r\n-")) {
                lastTag.setValue(v.substring(0, v.length() - 3));
            } else if (v.endsWith("\n-")) {
                lastTag.setValue(v.substring(0, v.length() - 2));
            }
        }
    }

    protected int textTagEndBlock4(String s, int start, boolean isTextBlock) {
        int i;
        for (i = start; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (c == 13 || c == 10) {
                int begin = i;
                if (i + 1 == s.length()) break;
                if ((c = s.charAt(++i)) == 13 || c == 10) {
                    if (i + 1 == s.length()) break;
                    c = s.charAt(++i);
                }
                if (!(isTextBlock || c != 123 && c != 125)) {
                    i = begin;
                    break;
                }
                if (c == 58 && i < s.length() && SwiftParser.tagStarts(s, i + 1)) {
                    i = begin;
                    break;
                }
                i = begin;
                continue;
            }
            if (c == 45) {
                int n = c = i + 1 < s.length() ? (int)s.charAt(i + 1) : 32;
                if (c == 125 && isTextBlock) break;
            }
            if (c == 125 && !isTextBlock) break;
        }
        return i;
    }

    private static final boolean tagStarts(String s, int i) {
        int length = s.length();
        if (i + 2 < length && Character.isDigit(s.charAt(i)) && Character.isDigit(s.charAt(i + 1))) {
            char c3 = s.charAt(i + 2);
            if (c3 == ':') {
                return true;
            }
            if (Character.isUpperCase(c3) && i + 3 < length && s.charAt(i + 3) == ':') {
                return true;
            }
        }
        return false;
    }

    private int blockTagEnd(String s, int start) {
        char c;
        int balance = 0;
        do {
            c = s.charAt(start++);
            switch (c) {
                case '{': {
                    ++balance;
                    break;
                }
                case '}': {
                    --balance;
                }
            }
        } while (start < s.length() && (balance >= 0 || balance == 0 && c != '}'));
        return start;
    }

    protected Tag consumeTag(String buffer, String unparsedText) throws IOException {
        char c;
        String value;
        int sep = buffer.indexOf(58);
        String name = null;
        if (sep != -1) {
            name = buffer.substring(0, sep);
            value = buffer.substring(sep + 1);
        } else {
            value = buffer;
        }
        if (StringUtils.isEmpty(name) && StringUtils.isEmpty((String)value)) {
            return null;
        }
        int size = value.length();
        if (size > 0 && ((c = value.charAt(size - 1)) == '\r' || c == '\n')) {
            --size;
        }
        if (size > 0 && ((c = value.charAt(size - 1)) == '\r' || c == '\n')) {
            --size;
        }
        if (size != value.length()) {
            value = value.substring(0, size);
        }
        Tag t = new Tag();
        if (name == null) {
            log.severe("Avoiding tag with null name and value " + value);
            throw new IllegalArgumentException("Null name and value");
        }
        t.setName(name);
        t.setValue(value);
        if (unparsedText != null) {
            t.setUnparsedTexts(this.processUnparsedText(unparsedText));
        }
        return t;
    }

    private UnparsedTextList processUnparsedText(String unparsedText) {
        UnparsedTextList list = null;
        int start = 0;
        while (start < unparsedText.length()) {
            int end = start + 1;
            while (end + 1 < unparsedText.length() && !unparsedText.startsWith("{1:", end)) {
                for (end = this.blockTagEnd(unparsedText, end + 1); end < unparsedText.length() && Character.isWhitespace(unparsedText.charAt(end)); ++end) {
                }
            }
            String text = unparsedText.substring(start, end).trim();
            if (!"".equals(text)) {
                if (list == null) {
                    list = new UnparsedTextList();
                }
                list.addText(text);
            }
            start = end;
        }
        return list;
    }

    protected char identifyBlock(String s) {
        if (s != null && s.length() > 1) {
            char c = s.charAt(0);
            if ('0' <= c && c <= '9') {
                return c;
            }
            if ('a' <= c && c <= 'z') {
                return c;
            }
            if ('A' <= c && c <= 'Z') {
                return c;
            }
        }
        return ' ';
    }

    protected String readUntilBlockEnds() throws IOException {
        int start = this.buffer == null ? 0 : this.buffer.length();
        int len = 0;
        boolean checkNested = true;
        int starts = 1;
        boolean done = false;
        int count = 0;
        Boolean isTextBlock = null;
        while (!done) {
            int c = this.getChar();
            if (isTextBlock == null && count++ >= 3 && (isTextBlock = Boolean.valueOf(this.isTextBlock())).booleanValue()) {
                checkNested = false;
            }
            if (c == -1) {
                done = true;
                continue;
            }
            if (checkNested && this.isBlockStart((char)c)) {
                ++starts;
            }
            if (this.isBlockEnd(isTextBlock, c)) {
                if (checkNested) {
                    if (--starts == 0) {
                        done = true;
                        continue;
                    }
                    ++len;
                    continue;
                }
                done = true;
                continue;
            }
            ++len;
        }
        int end = start + len;
        return this.buffer.substring(start, end);
    }

    private boolean isTextBlock() {
        if (this.lastBlockStartOffset >= 0 && this.buffer.length() > this.lastBlockStartOffset) {
            return this.isTextBlock(this.buffer.substring(this.lastBlockStartOffset));
        }
        return false;
    }

    private boolean isTextBlock(String s) {
        if (s.length() < 3) {
            return false;
        }
        int offset = s.charAt(0) == '{' ? 1 : 0;
        char c1 = s.charAt(offset + 0);
        char c2 = s.charAt(offset + 1);
        if (c1 == '4' && c2 == ':') {
            int c = offset + 2;
            while (offset + c < s.length()) {
                char tmp = s.charAt(offset + c);
                ++c;
                if (tmp == '{') {
                    return false;
                }
                if (tmp != ':') continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private final boolean isBlockEnd(Boolean isTextBlock, int curChar) {
        if (SwiftParser.isBlockEnd((char)curChar)) {
            if (isTextBlock != null && isTextBlock.booleanValue()) {
                char ult = this.buffer.charAt(this.buffer.length() - 2);
                char antUlt = this.buffer.charAt(this.buffer.length() - 3);
                if (antUlt == '\n' && ult == '-') {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private static final boolean isBlockEnd(char c) {
        return c == '}';
    }

    protected String findBlockStart() throws IOException {
        int c;
        StringBuilder textUntilBlock = new StringBuilder();
        do {
            c = this.getChar();
            textUntilBlock.append((char)c);
        } while (c != -1 && !this.isBlockStart((char)c));
        if (textUntilBlock.length() > 0) {
            textUntilBlock.deleteCharAt(textUntilBlock.length() - 1);
        }
        return textUntilBlock.length() > 0 ? textUntilBlock.toString() : "";
    }

    private boolean isBlockStart(char c) {
        if (c == '{') {
            this.lastBlockStartOffset = this.buffer.length() - 1;
            return true;
        }
        return false;
    }

    private final int getChar() throws IOException {
        int c = this.reader.read();
        if (c >= 0) {
            this.buffer.append((char)c);
        }
        return c;
    }

    public List getErrors() {
        return new ArrayList(this.errors);
    }

    @Deprecated
    public boolean isLenient() {
        DeprecationUtils.phase3(this.getClass(), "isLenient()", "Use getConfiguration()#isLenient() instead.");
        return this.configuration.isLenient();
    }

    @Deprecated
    public void setLenient(boolean lenient) {
        DeprecationUtils.phase3(this.getClass(), "setLenient(boolean)", "Use getConfiguration()#setLenient(boolean) instead.");
        this.configuration.setLenient(lenient);
    }

    public SwiftParserConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SwiftParserConfiguration configuration) {
        this.configuration = configuration;
    }

    public static SwiftBlock4 parseBlock4(String s) throws IOException {
        SwiftBlock4 b4 = new SwiftBlock4();
        String toParse = s;
        if (toParse.startsWith("{")) {
            toParse = toParse.substring(1);
        }
        if (toParse.endsWith("}")) {
            toParse = toParse.substring(0, toParse.length() - 1);
        }
        SwiftParser parser = new SwiftParser();
        return parser.block4Consume(b4, toParse);
    }

    public static SwiftBlock3 parseBlock3(String s) throws IOException {
        SwiftBlock3 b3 = new SwiftBlock3();
        SwiftParser parser = new SwiftParser();
        return (SwiftBlock3)parser.tagListBlockConsume(b3, s);
    }

    public static SwiftBlock5 parseBlock5(String s) throws IOException {
        SwiftBlock5 b5 = new SwiftBlock5();
        SwiftParser parser = new SwiftParser();
        return (SwiftBlock5)parser.tagListBlockConsume(b5, s);
    }

    public static SwiftBlock1 parseBlock1(String s) throws IOException {
        return new SwiftBlock1(StringUtils.strip((String)s, (String)"{}"), true);
    }

    public static SwiftBlock2 parseBlock2(String s) throws IOException {
        if (SwiftParser.isInput(s)) {
            return new SwiftBlock2Input(StringUtils.strip((String)s, (String)"{}"), true);
        }
        return new SwiftBlock2Output(StringUtils.strip((String)s, (String)"{}"), true);
    }

    public static SwiftBlock2Input parseBlock2Input(String s) throws IOException {
        return new SwiftBlock2Input(StringUtils.strip((String)s, (String)"{}"), true);
    }

    public static SwiftBlock2Output parseBlock2Output(String s) throws IOException {
        return new SwiftBlock2Output(StringUtils.strip((String)s, (String)"{}"), true);
    }
}

