/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.utils.IsoUtils;
import org.apache.commons.lang.StringUtils;

public class BIC {
    public static final transient String TEST8 = "TESTUS00";
    public static final transient String TEST12 = "TESTAR00AXXX";
    public static final String PARTNER_PREFIX = "PTS";
    private String invalidCause = null;
    private String bic8 = null;
    protected String branch = null;
    private String subtype = null;

    public BIC(String bic) {
        this.parse(bic);
    }

    protected void parse(String bic) {
        if (bic != null) {
            if (bic.length() >= 8) {
                this.bic8 = bic.substring(0, 8);
            }
            if (bic.length() == 11 || bic.length() == 12) {
                this.branch = bic.substring(bic.length() - 3, bic.length());
            }
        }
    }

    public BIC() {
    }

    @Deprecated
    public String getBic() {
        DeprecationUtils.phase3(this.getClass(), "getBic()", "Use getBic8() or getBic11() instead.");
        StringBuilder sb = new StringBuilder();
        if (this.bic8 != null) {
            sb.append(this.bic8);
        }
        if (this.branch != null) {
            sb.append(this.branch);
        }
        return sb.toString();
    }

    @Deprecated
    public void setBic(String bic) {
        DeprecationUtils.phase3(this.getClass(), "getBic()", "Use the constructor instead, passing the BIC value as String parameter.");
        this.parse(bic);
    }

    public String getInvalidCause() {
        return this.invalidCause;
    }

    public boolean isValid() {
        if (this.bic8 == null) {
            this.invalidCause = "BIC is null";
            return false;
        }
        if (this.bic8.length() != 8) {
            this.invalidCause = "Expected 8 characters for the institution and country code and found " + this.bic8.length() + " in " + this.bic8;
            return false;
        }
        if (this.branch != null && this.branch.length() != 3) {
            this.invalidCause = "Expected 3 characters for branch and found " + this.branch.length() + " in " + this.branch;
            return false;
        }
        String country = this.bic8.substring(4, 6);
        if (!IsoUtils.getInstance().isValidISOCountry(country)) {
            this.invalidCause = "Invalid country code " + country;
            return false;
        }
        String b11 = this.getBic11();
        for (int i = 0; i < b11.length(); ++i) {
            char c = b11.charAt(i);
            boolean digit = Character.isDigit(c);
            boolean uppercase = Character.isUpperCase(c);
            if (digit || uppercase) continue;
            this.invalidCause = "BIC characters must be alphanumeric uppercase";
            return false;
        }
        return true;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public boolean isTestAndTraining() {
        if (this.bic8 != null && this.bic8.length() >= 8) {
            return this.bic8.charAt(7) == '0';
        }
        return false;
    }

    public boolean isNonLive() {
        if (this.bic8 != null && this.bic8.length() >= 8) {
            return this.bic8.charAt(7) == '1';
        }
        return false;
    }

    public boolean isLive() {
        if (this.bic8 != null && this.bic8.length() >= 8) {
            return this.bic8.charAt(7) != '0' && this.bic8.charAt(7) != '1';
        }
        return false;
    }

    public String getBic8() {
        return this.bic8;
    }

    public String getBic11() {
        String branch;
        String string = branch = this.branch != null ? this.branch : "XXX";
        if (this.bic8 != null) {
            return this.bic8 + branch;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bic8 == null ? 0 : this.bic8.hashCode());
        result = 31 * result + (this.branch == null ? 0 : this.branch.hashCode());
        result = 31 * result + (this.invalidCause == null ? 0 : this.invalidCause.hashCode());
        result = 31 * result + (this.subtype == null ? 0 : this.subtype.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BIC other = (BIC)obj;
        if (this.bic8 == null ? other.bic8 != null : !this.bic8.equals(other.bic8)) {
            return false;
        }
        if (this.branch == null ? other.branch != null : !this.branch.equals(other.branch)) {
            return false;
        }
        if (this.invalidCause == null ? other.invalidCause != null : !this.invalidCause.equals(other.invalidCause)) {
            return false;
        }
        return !(this.subtype == null ? other.subtype != null : !this.subtype.equals(other.subtype));
    }

    public String country() {
        return StringUtils.substring((String)this.bic8, (int)4, (int)6);
    }

    public String institution() {
        return StringUtils.substring((String)this.bic8, (int)0, (int)4);
    }

    public String distinguishedName() {
        StringBuilder result = new StringBuilder();
        if (this.branch != null && !this.branch.equals("XXX")) {
            result.append("ou=").append(StringUtils.lowerCase((String)this.branch)).append(",");
        }
        result.append("o=").append(StringUtils.lowerCase((String)this.getBic8())).append(",o=swift");
        return result.toString();
    }

    public String toString() {
        return this.getBic11();
    }
}

