/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.BbanEntryType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.text.StrSubstitutor;

public enum IbanValidationResult {
    OK("IBAN is ok"),
    IBAN_IS_NULL("The IBAN is null"),
    IBAN_IS_EMPTY("The IBAN is empty"),
    MISSING_COUNTRY_CODE("The IBAN must start with the two letters ISO country code"),
    INVALID_COUNTRY_CODE_CHARSET("The country code must contain upper case letters and ${found} was found"),
    INVALID_COUNTRY_CODE("The country code ${found} is not a valid ISO country code or the country code is not configured for IBAN validations"),
    INVALID_CHARACTERS("Invalid character '${found}' found"),
    MISSING_CHECK_DIGITS("Missing check digits"),
    INVALID_CHECK_DIGITS_FORMAT("Expected 2 check digits and found ${found}"),
    IVALID_CHECK_DIGITS("The expected computed check digit is ${expectedCheckDigit} and ${found} was found"),
    MISSING_BBAN("Missing custom account number (BBAN)"),
    BBAN_MAX_LENGTH("The max length for the custom account number (BBAN) is ${expectedLength} and found ${foundLength}"),
    MISSING_BBAN_CONFIGURATION("Missing custom account number (BBAN) configuration for country ${found}"),
    BBAN_INVALID_LENGTH("Expected a ${expectedLength} characters length for the custom account number (BBAN) and found ${foundLength} in ${found}"),
    BBAN_INVALID_UPPER_CASE_LETTERS("The ${bbanEntryType} ${found} must contain only upper case letters"),
    BBAN_INVALID_DIGITS_OR_LETTERS("The ${bbanEntryType} ${found} must contain only digits or upper case letters"),
    BBAN_INVALID_DIGITS("The ${bbanEntryType} ${found} must contain only digits"),
    UNKNOWN("Unknown exception validating IBAN");

    private String message;
    private Map<String, String> vars = new HashMap<String, String>();

    private IbanValidationResult(String message) {
        this.message = message;
    }

    public String message() {
        StrSubstitutor sub = new StrSubstitutor(this.vars);
        return sub.replace(this.message);
    }

    void setFound(String found) {
        this.vars.put("found", found);
    }

    void setExpectedLength(int expectedLength) {
        this.vars.put("expectedLength", String.valueOf(expectedLength));
    }

    void setFoundLength(int foundLength) {
        this.vars.put("foundLength", String.valueOf(foundLength));
    }

    void setBbanEntryType(BbanEntryType type) {
        this.vars.put("bbanEntryType", type.name());
    }

    void setExpectedCheckDigit(String expectedCheckDigit) {
        this.vars.put("expectedCheckDigit", expectedCheckDigit);
    }

    public Map<String, String> vars() {
        return this.vars;
    }
}

