/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.io.ConversionService;
import com.prowidesoftware.swift.io.parser.SwiftParser;
import com.prowidesoftware.swift.io.parser.SwiftParserConfiguration;
import com.prowidesoftware.swift.model.AbstractSwiftMessage;
import com.prowidesoftware.swift.model.CurrencyAmount;
import com.prowidesoftware.swift.model.FileFormat;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessageUtils;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.model.mt.ServiceIdType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class MtSwiftMessage
extends AbstractSwiftMessage {
    private static final transient Logger log = Logger.getLogger(MtSwiftMessage.class.getName());
    private static final long serialVersionUID = -5972656648349958815L;
    private String pde;
    private String pdm;
    private String mir;
    private String mur;
    private String uuid;

    public MtSwiftMessage() {
    }

    public MtSwiftMessage(String fin) {
        super(fin, FileFormat.FIN);
    }

    public static MtSwiftMessage parse(String fin) {
        return new MtSwiftMessage(fin);
    }

    public MtSwiftMessage(InputStream stream) throws IOException {
        super(stream, FileFormat.FIN);
    }

    public static MtSwiftMessage parse(InputStream stream) throws IOException {
        return new MtSwiftMessage(stream);
    }

    public MtSwiftMessage(File file) throws IOException {
        super(file, FileFormat.FIN);
    }

    public static MtSwiftMessage parse(File file) throws IOException {
        return new MtSwiftMessage(file);
    }

    @Override
    protected void updateFromMessage() throws IllegalArgumentException {
        if (this.getFileFormat() != FileFormat.FIN) {
            throw new IllegalArgumentException("expected source format " + (Object)((Object)FileFormat.FIN) + " and found " + (Object)((Object)this.getFileFormat()));
        }
        Validate.notNull((Object)this.getMessage(), (String)"the raw message attribute cannot be null");
        SwiftParser parser = new SwiftParser(this.getMessage());
        SwiftParserConfiguration config = new SwiftParserConfiguration();
        config.setLenient(true);
        parser.setConfiguration(config);
        SwiftMessage model = null;
        try {
            model = parser.message();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "the raw message parameter could not be parsed into a SwiftMessage", e);
        }
        if (model == null) {
            throw new IllegalArgumentException("the raw message parameter could not be parsed into a SwiftMessage");
        }
        this.updateAttributes(model);
    }

    private void updateAttributes(SwiftMessage model) {
        this.setFileFormat(FileFormat.FIN);
        if (model.isServiceMessage21()) {
            if (model.getUnparsedTextsSize() > 0) {
                if (model.isAck()) {
                    this.identifier = "ACK";
                } else if (model.isNack()) {
                    this.identifier = "NAK";
                }
                SwiftMessage original = model.getUnparsedTexts().getTextAsMessage(0);
                if (original != null) {
                    this.receiver = this.bic11(original.getReceiver());
                    this.setDirection(original.getDirection());
                    this.setReference(SwiftMessageUtils.reference(original));
                }
            }
        } else if (model.getBlock1() != null && model.getBlock1().getServiceIdType() == ServiceIdType._01) {
            this.setIdentifier(model.getMtId().id());
            this.setReceiver(this.bic11(model.getReceiver()));
            this.setDirection(model.getDirection());
            this.setReference(SwiftMessageUtils.reference(model));
            CurrencyAmount currencyAmount = SwiftMessageUtils.currencyAmount(model);
            if (currencyAmount != null) {
                this.setCurrency(currencyAmount.getCurrency());
                this.setAmount(currencyAmount.getAmount());
            }
        }
        this.setSender(this.bic11(model.getSender()));
        this.setChecksum(SwiftMessageUtils.calculateChecksum(model));
        this.setChecksumBody(SwiftMessageUtils.calculateChecksum(model.getBlock4()));
        this.setPde(model.getPDE());
        this.setPdm(model.getPDM());
        this.setMir(model.getMIR());
        this.setMur(model.getMUR());
        this.setUuid(model.getUUID());
        this.setLastModified(Calendar.getInstance());
    }

    public MtSwiftMessage(SwiftMessage model) {
        this.updateFromModel(model);
    }

    public void updateFromFIN(String fin) {
        Validate.notNull((Object)fin, (String)"the raw message parameter cannot be null");
        this.setMessage(fin);
        this.setFileFormat(FileFormat.FIN);
        this.updateFromMessage();
    }

    public void updateFromFIN() {
        this.updateFromMessage();
    }

    public void updateFromModel(SwiftMessage model) {
        Validate.notNull((Object)model, (String)"the model message cannot be null");
        String fin = new ConversionService().getFIN(model);
        Validate.notNull((Object)fin, (String)"the raw message could not be created from the SwiftMessage parameter");
        this.setMessage(fin);
        this.updateAttributes(model);
    }

    public void updateFromModel(AbstractMT mt) {
        Validate.notNull((Object)mt, (String)"the model message cannot be null");
        this.updateFromModel(mt.getSwiftMessage());
    }

    @Deprecated
    public void updateFromModel() {
        DeprecationUtils.phase3(this.getClass(), "updateFromModel()", "Use updateFromModel(SwiftMessage) or constructor MtSwiftMessage(SwiftMessage) instead.");
    }

    @Deprecated
    public SwiftMessage getModelMessage() {
        DeprecationUtils.phase2(this.getClass(), "getModelMessage()", "Use modelMessage() instead.");
        return this.modelMessage();
    }

    public SwiftMessage modelMessage() {
        if (this.getMessage() != null) {
            SwiftParser parser = new SwiftParser(this.getMessage());
            parser.getConfiguration().setLenient(true);
            try {
                return parser.message();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "error converting FIN text to model: " + e.getMessage(), e);
            }
        }
        return null;
    }

    @Deprecated
    public void setModelMessage(SwiftMessage modelMessage) {
        DeprecationUtils.phase2(this.getClass(), "setModelMessage(SwiftMessage)", "Use updateFromModel(SwiftMessage) instead.");
        this.updateFromModel(modelMessage);
    }

    public String getMessageType() {
        if (this.identifier != null && this.isMT()) {
            return this.identifier.replaceAll("\\D+", "");
        }
        return this.getIdentifier();
    }

    public Integer getMessageTypeInt() {
        String number = this.getMessageType();
        if (number != null && StringUtils.isNumeric((String)number)) {
            return Integer.parseInt(number);
        }
        return null;
    }

    @Override
    public String getMessageName() {
        String name = super.getMessageName();
        if (name != null) {
            return name;
        }
        return this.getMessageType();
    }

    public boolean isType(Integer ... type) {
        for (Integer integer : type) {
            if (!this.isType((int)integer)) continue;
            return true;
        }
        return false;
    }

    public boolean isType(int type) {
        String compare = type < 10 ? "00" + type : (type < 100 ? "0" + type : "" + type);
        return StringUtils.equals((String)compare, (String)this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MtSwiftMessage id=").append(this.getId()).append(" message=").append(this.getMessage());
        return sb.toString();
    }

    public String getPde() {
        return this.pde;
    }

    public void setPde(String pde) {
        this.pde = pde;
    }

    public String getPdm() {
        return this.pdm;
    }

    public void setPdm(String pdm) {
        this.pde = pdm;
    }

    public String getMir() {
        return this.mir;
    }

    public void setMir(String mir) {
        this.mir = mir;
    }

    public String getMur() {
        return this.mur;
    }

    public void setMur(String mur) {
        this.mur = mur;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mir == null ? 0 : this.mir.hashCode());
        result = 31 * result + (this.mur == null ? 0 : this.mur.hashCode());
        result = 31 * result + (this.pde == null ? 0 : this.pde.hashCode());
        result = 31 * result + (this.pdm == null ? 0 : this.pdm.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MtSwiftMessage other = (MtSwiftMessage)obj;
        if (this.mir == null ? other.mir != null : !this.mir.equals(other.mir)) {
            return false;
        }
        if (this.mur == null ? other.mur != null : !this.mur.equals(other.mur)) {
            return false;
        }
        if (this.pde == null ? other.pde != null : !this.pde.equals(other.pde)) {
            return false;
        }
        if (this.pdm == null ? other.pdm != null : !this.pdm.equals(other.pdm)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    @Override
    @Deprecated
    public MtSwiftMessage readFile(File file) throws IOException {
        DeprecationUtils.phase3(this.getClass(), "readFile(File)", "Use the constructor MtSwiftMessage(File) instead.");
        return new MtSwiftMessage(file);
    }

    public void copyTo(MtSwiftMessage msg) {
        super.copyTo(msg);
        msg.setMir(this.getMir());
        msg.setMur(this.getMur());
        msg.setPde(this.getPde());
        msg.setPdm(this.getPdm());
        msg.setUuid(this.getUuid());
    }
}

