/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.Validate;

public class SwiftBlock5
extends SwiftTagListBlock
implements Serializable {
    private static final transient Logger log = Logger.getLogger(SwiftBlock5.class.getName());
    private static final long serialVersionUID = 3114133378482486859L;

    public SwiftBlock5() {
    }

    public SwiftBlock5(List<Tag> tags) {
        Validate.notNull(tags, (String)"parameter 'tags' cannot be null");
        Validate.allElementsOfType(tags, Tag.class, (String)"parameter 'tags' may only have Tag elements");
        this.addTags(tags);
    }

    @Override
    protected void setBlockNumber(Integer blockNumber) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((blockNumber == 5 ? 1 : 0) != 0, (String)"blockNumber must be 5");
    }

    @Override
    protected void setBlockName(String blockName) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((blockName.compareTo("5") == 0 ? 1 : 0) != 0, (String)"blockName must be string '5'");
    }

    @Override
    public Integer getNumber() {
        return 5;
    }

    @Override
    public String getName() {
        return "5";
    }
}

