/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.SwiftCharset;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class SwiftCharsetUtils {
    public static int OK = -1;

    private SwiftCharsetUtils() {
        throw new AssertionError();
    }

    public static boolean is_n(char c) {
        return SwiftCharsetUtils.is(c, SwiftCharsetUtils.get_n());
    }

    public static int is_n(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharsetUtils.get_n());
    }

    public static boolean is_a(char c) {
        return SwiftCharsetUtils.is(c, SwiftCharsetUtils.get_a());
    }

    public static int is_a(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharsetUtils.get_a());
    }

    public static boolean is_x(char c) {
        return SwiftCharsetUtils.is(c, SwiftCharsetUtils.get_x());
    }

    public static int is_x(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharsetUtils.get_x());
    }

    public static boolean is_y(char c) {
        return SwiftCharsetUtils.is(c, SwiftCharsetUtils.get_y());
    }

    public static int is_y(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharsetUtils.get_y());
    }

    public static boolean is_z(char c) {
        return SwiftCharsetUtils.is(c, SwiftCharsetUtils.get_z());
    }

    public static int is_z(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharsetUtils.get_z());
    }

    public static boolean is_c(char c) {
        return SwiftCharsetUtils.is(c, SwiftCharsetUtils.get_c());
    }

    public static int is_c(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharsetUtils.get_c());
    }

    public static boolean is_A(char c) {
        return SwiftCharsetUtils.is(c, SwiftCharsetUtils.get_A());
    }

    public static int is_A(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharsetUtils.get_A());
    }

    public static boolean is_B(char c) {
        return SwiftCharsetUtils.is(c, SwiftCharsetUtils.get_B());
    }

    public static int is_B(String s) {
        return SwiftCharsetUtils.is(s, SwiftCharsetUtils.get_B());
    }

    private static int is(String s, char[] charset) {
        if (StringUtils.isNotEmpty((String)s)) {
            for (int i = 0; i < s.length(); ++i) {
                if (SwiftCharsetUtils.is(s.charAt(i), charset)) continue;
                return i;
            }
        }
        return OK;
    }

    public static int is(String s, SwiftCharset charset) {
        if (SwiftCharset.n.equals((Object)charset)) {
            return SwiftCharsetUtils.is_n(s);
        }
        if (SwiftCharset.a.equals((Object)charset)) {
            return SwiftCharsetUtils.is_a(s);
        }
        if (SwiftCharset.A.equals((Object)charset)) {
            return SwiftCharsetUtils.is_A(s);
        }
        if (SwiftCharset.x.equals((Object)charset)) {
            return SwiftCharsetUtils.is_x(s);
        }
        if (SwiftCharset.y.equals((Object)charset)) {
            return SwiftCharsetUtils.is_y(s);
        }
        if (SwiftCharset.z.equals((Object)charset)) {
            return SwiftCharsetUtils.is_z(s);
        }
        if (SwiftCharset.c.equals((Object)charset)) {
            return SwiftCharsetUtils.is_c(s);
        }
        if (SwiftCharset.B.equals((Object)charset)) {
            return SwiftCharsetUtils.is_B(s);
        }
        throw new RuntimeException("unexpected charset enum");
    }

    public static boolean is(char c, SwiftCharset charset) {
        if (SwiftCharset.n.equals((Object)charset)) {
            return SwiftCharsetUtils.is_n(c);
        }
        if (SwiftCharset.a.equals((Object)charset)) {
            return SwiftCharsetUtils.is_a(c);
        }
        if (SwiftCharset.A.equals((Object)charset)) {
            return SwiftCharsetUtils.is_A(c);
        }
        if (SwiftCharset.x.equals((Object)charset)) {
            return SwiftCharsetUtils.is_x(c);
        }
        if (SwiftCharset.y.equals((Object)charset)) {
            return SwiftCharsetUtils.is_y(c);
        }
        if (SwiftCharset.z.equals((Object)charset)) {
            return SwiftCharsetUtils.is_z(c);
        }
        if (SwiftCharset.c.equals((Object)charset)) {
            return SwiftCharsetUtils.is_c(c);
        }
        if (SwiftCharset.B.equals((Object)charset)) {
            return SwiftCharsetUtils.is_B(c);
        }
        throw new RuntimeException("unexpected charset enum");
    }

    public static String getAsString(SwiftCharset charset) {
        String result = null;
        if (SwiftCharset.n.equals((Object)charset)) {
            result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_n());
        } else if (SwiftCharset.a.equals((Object)charset)) {
            result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_a());
        } else if (SwiftCharset.A.equals((Object)charset)) {
            result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_A());
        } else if (SwiftCharset.x.equals((Object)charset)) {
            result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_x());
        } else if (SwiftCharset.y.equals((Object)charset)) {
            result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_y());
        } else if (SwiftCharset.z.equals((Object)charset)) {
            result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_z());
        } else if (SwiftCharset.c.equals((Object)charset)) {
            result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_c());
        } else if (SwiftCharset.B.equals((Object)charset)) {
            result = SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_B());
        } else {
            throw new RuntimeException("unexpected charset enum");
        }
        result = StringUtils.replace((String)result, (String)SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_n()), (String)"[0-9]");
        result = StringUtils.replace((String)result, (String)SwiftCharsetUtils.getAsString(SwiftCharsetUtils.get_a()), (String)"[A-Z]");
        result = StringUtils.replace((String)result, (String)SwiftCharsetUtils.getAsString(SwiftCharsetUtils._get_az()), (String)"[a-z]");
        return result;
    }

    private static boolean is(char c, char[] charset) {
        return ArrayUtils.contains((char[])charset, (char)c);
    }

    public static char[] get_n() {
        char[] result = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        return result;
    }

    public static char[] get_a() {
        char[] result = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        return result;
    }

    private static char[] _get_az() {
        char[] result = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        return result;
    }

    public static char[] get_A() {
        char[] result = SwiftCharsetUtils.get_a();
        return ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils._get_az());
    }

    public static char[] get_x() {
        char[] result = new char[]{'/', '-', '?', ':', '(', ')', '.', ',', '\'', '+', ' ', '\n', '\r'};
        result = ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_A());
        result = ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_n());
        return result;
    }

    public static char[] get_y() {
        char[] result = new char[]{' ', '.', ',', '-', '(', ')', '/', '=', '\'', '+', ':', '?', '!', '\"', '%', '&', '*', ';', '<', '>'};
        result = ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_a());
        result = ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_n());
        return result;
    }

    public static char[] get_z() {
        char[] result = new char[]{'.', ',', '-', '(', ')', '/', '=', '\'', '+', ':', '?', '@', '#', ' ', '{', '!', '\"', '%', '&', '*', ';', '<', '>', '_', '\n', '\r'};
        result = ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_A());
        result = ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_n());
        return result;
    }

    public static char[] get_c() {
        char[] result = SwiftCharsetUtils.get_a();
        return ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_n());
    }

    public static char[] get_B() {
        char[] result = SwiftCharsetUtils.get_A();
        return ArrayUtils.addAll((char[])result, (char[])SwiftCharsetUtils.get_n());
    }

    public static String getAsString(char[] charset) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < charset.length; ++i) {
            String ch = null;
            ch = charset[i] == '\n' ? "LF" : (charset[i] == '\r' ? "CR" : "" + charset[i]);
            result.append("[");
            result.append(ch);
            result.append("]");
        }
        return result.toString();
    }

    public static String filter(String s, SwiftCharset charset) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (!SwiftCharsetUtils.is(s.charAt(i), charset)) continue;
            result.append(s.charAt(i));
        }
        return result.toString();
    }
}

