/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.SwiftBlock;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SwiftValueBlock
extends SwiftBlock
implements Serializable {
    private static final long serialVersionUID = -3680693640473937755L;
    private static final transient Logger log = Logger.getLogger(SwiftValueBlock.class.getName());

    protected SwiftValueBlock() {
    }

    public String getBlockValue() {
        throw new UnsupportedOperationException("cannot call getBlockValue on SwiftValueBlock, must be on specific subclasses");
    }

    public String getValue() {
        throw new UnsupportedOperationException("cannot call getValue on SwiftValueBlock, must be on specific subclasses");
    }

    public void setValue(String value) {
        throw new UnsupportedOperationException("cannot call setValue on SwiftValueBlock, must be on specific subclasses");
    }

    public void setBlockValue(String value) {
        throw new UnsupportedOperationException("cannot call setBlockValue on SwiftValueBlock, must be on specific subclasses");
    }

    public boolean isEmpty() {
        return this.getValue() == null;
    }

    public int size() {
        return this.getValue() == null ? 0 : this.getValue().length();
    }

    protected String getValuePart(String value, int start, int size) {
        String s = null;
        if (start < value.length()) {
            int boundedSize = start + size >= value.length() ? value.length() - start : size;
            try {
                s = value.substring(start, start + boundedSize);
            }
            catch (IndexOutOfBoundsException e) {
                log.log(Level.SEVERE, "Exception parsing value part", e);
            }
        }
        return s;
    }

    protected String getValuePart(String value, int start) {
        if (start < value.length()) {
            return value.substring(start);
        }
        return null;
    }
}

