/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.field.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class AmountResolver {
    private static final Logger log = Logger.getLogger(AmountResolver.class.getName());

    @Deprecated
    public static List<BigDecimal> amounts(Field f, int ... component) {
        DeprecationUtils.phase2(AmountResolver.class, "amounts(File, int ...)", "Use amounts(Field) instead.");
        return AmountResolver.amounts(f);
    }

    public static List<BigDecimal> amounts(Field f) {
        Validate.notNull((Object)f);
        ArrayList<BigDecimal> amounts = new ArrayList<BigDecimal>();
        int i = StringUtils.indexOf((String)f.componentsPattern(), (char)'N');
        while (i >= 0) {
            BigDecimal amount = AmountResolver.amount(f, i + 1);
            if (amount != null) {
                amounts.add(amount);
            }
            i = StringUtils.indexOf((String)f.componentsPattern(), (char)'N', (int)(i + 1));
        }
        return amounts;
    }

    public static BigDecimal amount(Field f) {
        Validate.notNull((Object)f);
        int i = StringUtils.indexOf((String)f.componentsPattern(), (char)'N');
        if (i >= 0) {
            return AmountResolver.amount(f, i + 1);
        }
        return null;
    }

    private static BigDecimal amount(Field f, int component) {
        Number n = (Number)f.getComponentAs(component, Number.class);
        if (n == null) {
            log.warning("getComponentAs(" + component + ", Number.class) returned null for field " + f);
            return null;
        }
        return new BigDecimal(n.toString());
    }
}

