/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field11S
extends Field
implements Serializable,
DateContainer,
MultiLineField {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "11S";
    public static final String F_11S = "11S";
    public static final String PARSER_PATTERN = "S$<DATE2>[$4!S6!S]";
    public static final String COMPONENTS_PATTERN = "MENN";
    public static final Integer MT = 1;
    public static final Integer DATE = 2;
    public static final Integer SESSION_NUMBER = 3;
    public static final Integer ISN = 4;

    public Field11S() {
        super(4);
    }

    public Field11S(String value) {
        super(value);
    }

    public Field11S(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"11S")) {
            throw new IllegalArgumentException("cannot create field 11S from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(4);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (lines.isEmpty()) {
            return;
        }
        this.setComponent1(lines.get(0));
        if (lines.size() > 1) {
            this.setComponent2(lines.get(1));
        }
        if (lines.size() > 2) {
            String toparse = lines.get(2);
            if (toparse != null && toparse.length() >= 4) {
                this.setComponent3(StringUtils.substring((String)toparse, (int)0, (int)4));
                if (toparse.length() > 4) {
                    this.setComponent4(StringUtils.substring((String)toparse, (int)4));
                }
            } else {
                this.setComponent3(toparse);
            }
        }
    }

    public static Field11S newInstance(Field11S source) {
        Field11S cp = new Field11S();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            result.append("\r\n").append(this.getComponent2());
        }
        if (this.getComponent3() != null || this.getComponent4() != null) {
            result.append("\r\n");
            this.append(result, 3);
            this.append(result, 4);
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("11S", value);
    }

    public static Tag emptyTag() {
        return new Tag("11S", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getMT() {
        return this.getComponent(1);
    }

    public Field11S setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field11S setMT(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent(2);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public Field11S setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field11S setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate2(component2));
        return this;
    }

    public Field11S setDate(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field11S setDate(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getSessionNumber() {
        return this.getComponent(3);
    }

    public Number getSessionNumberAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public Field11S setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field11S setComponent3(Number component3) {
        if (component3 != null) {
            this.setComponent(3, Integer.toString(component3.intValue()));
        }
        return this;
    }

    public Field11S setSessionNumber(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field11S setSessionNumber(Number component3) {
        this.setComponent3(component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getISN() {
        return this.getComponent(4);
    }

    public Number getISNAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field11S setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field11S setComponent4(Number component4) {
        if (component4 != null) {
            this.setComponent(4, Integer.toString(component4.intValue()));
        }
        return this;
    }

    public Field11S setISN(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field11S setISN(Number component4) {
        this.setComponent4(component4);
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate2(this.getComponent(2)));
        return result;
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 3) {
            return true;
        }
        return component == 4;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "11S";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<MT>$<DATE2>[$4!n6!n]";
    }

    public static Field11S get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("11S");
        if (t == null) {
            return null;
        }
        return new Field11S(t);
    }

    public static Field11S get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field11S.get(msg.getBlock4());
    }

    public static List<Field11S> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field11S.getAll(msg.getBlock4());
    }

    public static List<Field11S> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("11S");
        if (arr != null && arr.length > 0) {
            ArrayList<Field11S> result = new ArrayList<Field11S>(arr.length);
            for (Tag f : arr) {
                result.add(new Field11S(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field11S cp = Field11S.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field11S cp = Field11S.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field11S cp = Field11S.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        Format f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 11S");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 3) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            ((NumberFormat)f).setMaximumFractionDigits(13);
            n = this.getComponent3AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 4) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            ((NumberFormat)f).setMaximumFractionDigits(13);
            n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("MT");
        result.add("Date");
        result.add("Session Number");
        result.add("ISN");
        return result;
    }
}

