/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field12B
extends Field
implements Serializable,
GenericField {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "12B";
    public static final String F_12B = "12B";
    public static final String PARSER_PATTERN = ":S/[S]/S";
    public static final String COMPONENTS_PATTERN = "SSS";
    public static final Integer QUALIFIER = 1;
    public static final Integer DATA_SOURCE_SCHEME = 2;
    public static final Integer INSTRUMENT_TYPE_CODE = 3;
    public static final Integer CONDITIONAL_QUALIFIER = 3;

    public Field12B() {
        super(3);
    }

    public Field12B(String value) {
        super(value);
    }

    public Field12B(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"12B")) {
            throw new IllegalArgumentException("cannot create field 12B from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
        this.setComponent3(SwiftParseUtils.getTokenThirdLast(value, "/"));
    }

    public static Field12B newInstance(Field12B source) {
        Field12B cp = new Field12B();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("12B", value);
    }

    public static Tag emptyTag() {
        return new Tag("12B", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field12B setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field12B setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getDataSourceScheme() {
        return this.getComponent(2);
    }

    public Field12B setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field12B setDataSourceScheme(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getInstrumentTypeCode() {
        return this.getComponent(3);
    }

    public Field12B setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field12B setInstrumentTypeCode(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return this.getComponent2();
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "12B";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c/[8c]/4!c";
    }

    public static Field12B get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("12B");
        if (t == null) {
            return null;
        }
        return new Field12B(t);
    }

    public static Field12B get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field12B.get(msg.getBlock4());
    }

    public static List<Field12B> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field12B.getAll(msg.getBlock4());
    }

    public static List<Field12B> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("12B");
        if (arr != null && arr.length > 0) {
            ArrayList<Field12B> result = new ArrayList<Field12B>(arr.length);
            for (Tag f : arr) {
                result.add(new Field12B(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 12B");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Data Source Scheme");
        result.add("Instrument Type Code");
        return result;
    }
}

