/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field37D
extends Field
implements Serializable,
DateContainer,
AmountContainer {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "37D";
    public static final String F_37D = "37D";
    public static final String PARSER_PATTERN = "N[//<DATE2>cS][/S]";
    public static final String COMPONENTS_PATTERN = "NESNS";
    public static final Integer RATE = 1;
    public static final Integer DATE = 2;
    public static final Integer DM_MARK = 3;
    public static final Integer NUMBER_OF_DAYSMONTHS = 4;
    public static final Integer INFORMATION = 5;

    public Field37D() {
        super(5);
    }

    public Field37D(String value) {
        super(value);
    }

    public Field37D(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"37D")) {
            throw new IllegalArgumentException("cannot create field 37D from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(5);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "//"));
        String toparse = SwiftParseUtils.getTokenSecond(value, "//");
        if (toparse != null) {
            if (toparse.length() >= 6) {
                this.setComponent2(StringUtils.substring((String)toparse, (int)0, (int)6));
            }
            if (toparse.length() >= 7) {
                this.setComponent3(StringUtils.substring((String)toparse, (int)6, (int)7));
            }
            if (toparse.length() > 7) {
                String toparse2 = StringUtils.substring((String)toparse, (int)7);
                this.setComponent4(SwiftParseUtils.getTokenFirst(toparse2, "/"));
                this.setComponent5(SwiftParseUtils.getTokenSecondLast(toparse2, "/"));
            }
        }
    }

    public static Field37D newInstance(Field37D source) {
        Field37D cp = new Field37D();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null || this.getComponent3() != null || this.getComponent4() != null) {
            result.append("//");
            this.append(result, 2);
            this.append(result, 3);
            this.append(result, 4);
        }
        if (this.getComponent5() != null) {
            result.append("/").append(this.getComponent5());
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("37D", value);
    }

    public static Tag emptyTag() {
        return new Tag("37D", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Number getComponent1AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public String getRate() {
        return this.getComponent(1);
    }

    public Number getRateAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public Field37D setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field37D setComponent1(Number component1) {
        this.setComponent(1, SwiftFormatUtils.getNumber(component1));
        return this;
    }

    public Field37D setRate(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field37D setRate(Number component1) {
        this.setComponent1(component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent(2);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public Field37D setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field37D setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate2(component2));
        return this;
    }

    public Field37D setDate(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field37D setDate(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getDMMark() {
        return this.getComponent(3);
    }

    public Field37D setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field37D setDMMark(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getNumberofDaysMonths() {
        return this.getComponent(4);
    }

    public Number getNumberofDaysMonthsAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field37D setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field37D setComponent4(Number component4) {
        this.setComponent(4, SwiftFormatUtils.getNumber(component4));
        return this;
    }

    public Field37D setNumberofDaysMonths(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field37D setNumberofDaysMonths(Number component4) {
        this.setComponent4(component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public String getInformation() {
        return this.getComponent(5);
    }

    public Field37D setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field37D setInformation(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate2(this.getComponent(2)));
        return result;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        return component == 5;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "37D";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<AMOUNT>12[//<DATE2><DM>3n][/16x]";
    }

    public static Field37D get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("37D");
        if (t == null) {
            return null;
        }
        return new Field37D(t);
    }

    public static Field37D get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field37D.get(msg.getBlock4());
    }

    public static List<Field37D> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field37D.getAll(msg.getBlock4());
    }

    public static List<Field37D> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("37D");
        if (arr != null && arr.length > 0) {
            ArrayList<Field37D> result = new ArrayList<Field37D>(arr.length);
            for (Tag f : arr) {
                result.add(new Field37D(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        Format f;
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 37D");
        }
        if (component == 1) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            ((NumberFormat)f).setMaximumFractionDigits(13);
            n = this.getComponent1AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            ((NumberFormat)f).setMaximumFractionDigits(13);
            n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Rate");
        result.add("Date");
        result.add("D/M Mark");
        result.add("Number of Days/Months");
        result.add("Information");
        return result;
    }
}

