/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field38H
extends Field
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "38H";
    public static final String F_38H = "38H";
    public static final String PARSER_PATTERN = "NS/NS";
    public static final String COMPONENTS_PATTERN = "NSNS";
    public static final Integer NUMBER_FROM = 1;
    public static final Integer PERIOD_FROM = 2;
    public static final Integer NUMBER_TO = 3;
    public static final Integer PERIOD_TO = 4;

    public Field38H() {
        super(4);
    }

    public Field38H(String value) {
        super(value);
    }

    public Field38H(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"38H")) {
            throw new IllegalArgumentException("cannot create field 38H from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getNumericPrefix(StringUtils.substringBefore((String)value, (String)"/")));
        this.setComponent2(SwiftParseUtils.getAlphaSuffix(StringUtils.substringBefore((String)value, (String)"/")));
        String toparse = SwiftParseUtils.getTokenSecond(value, "/");
        this.setComponent3(SwiftParseUtils.getNumericPrefix(toparse));
        this.setComponent4(SwiftParseUtils.getAlphaSuffix(toparse));
    }

    public static Field38H newInstance(Field38H source) {
        Field38H cp = new Field38H();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        this.append(result, 4);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("38H", value);
    }

    public static Tag emptyTag() {
        return new Tag("38H", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Number getComponent1AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public String getNumberFrom() {
        return this.getComponent(1);
    }

    public Number getNumberFromAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public Field38H setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field38H setComponent1(Number component1) {
        if (component1 != null) {
            this.setComponent(1, Integer.toString(component1.intValue()));
        }
        return this;
    }

    public Field38H setNumberFrom(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field38H setNumberFrom(Number component1) {
        this.setComponent1(component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getPeriodFrom() {
        return this.getComponent(2);
    }

    public Field38H setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field38H setPeriodFrom(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getNumberTo() {
        return this.getComponent(3);
    }

    public Number getNumberToAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public Field38H setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field38H setComponent3(Number component3) {
        if (component3 != null) {
            this.setComponent(3, Integer.toString(component3.intValue()));
        }
        return this;
    }

    public Field38H setNumberTo(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field38H setNumberTo(Number component3) {
        this.setComponent3(component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    @Deprecated
    public String getComponent4AsString() {
        return this.getComponent(4);
    }

    public String getPeriodTo() {
        return this.getComponent(4);
    }

    public Field38H setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field38H setPeriodTo(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "38H";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "2n1a/2n1a";
    }

    public static Field38H get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("38H");
        if (t == null) {
            return null;
        }
        return new Field38H(t);
    }

    public static Field38H get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field38H.get(msg.getBlock4());
    }

    public static List<Field38H> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field38H.getAll(msg.getBlock4());
    }

    public static List<Field38H> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("38H");
        if (arr != null && arr.length > 0) {
            ArrayList<Field38H> result = new ArrayList<Field38H>(arr.length);
            for (Tag f : arr) {
                result.add(new Field38H(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        NumberFormat f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 38H");
        }
        if (component == 1) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent1AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent3AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Number From");
        result.add("Period From");
        result.add("Number To");
        result.add("Period To");
        return result;
    }
}

