/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field95P
extends Field
implements Serializable,
BICContainer,
GenericField {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "95P";
    public static final String F_95P = "95P";
    public static final String PARSER_PATTERN = ":S//S";
    public static final String COMPONENTS_PATTERN = "SB";
    public static final Integer QUALIFIER = 1;
    public static final Integer BIC = 2;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field95P() {
        super(2);
    }

    public Field95P(String value) {
        super(value);
    }

    public Field95P(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"95P")) {
            throw new IllegalArgumentException("cannot create field 95P from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "//"));
    }

    public static Field95P newInstance(Field95P source) {
        Field95P cp = new Field95P();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("95P", value);
    }

    public static Tag emptyTag() {
        return new Tag("95P", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field95P setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field95P setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BIC getComponent2AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(2));
    }

    public String getBIC() {
        return this.getComponent(2);
    }

    public BIC getBICAsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(2));
    }

    public Field95P setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field95P setComponent2(BIC component2) {
        this.setComponent(2, SwiftFormatUtils.getBIC(component2));
        return this;
    }

    public Field95P setBIC(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field95P setBIC(BIC component2) {
        this.setComponent2(component2);
        return this;
    }

    @Override
    public List<BIC> bics() {
        ArrayList<BIC> result = new ArrayList<BIC>();
        result.add(SwiftFormatUtils.getBIC(this.getComponent(2)));
        return result;
    }

    @Override
    public List<String> bicStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getComponent(2));
        return result;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "95P";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//<BIC>";
    }

    public static Field95P get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("95P");
        if (t == null) {
            return null;
        }
        return new Field95P(t);
    }

    public static Field95P get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field95P.get(msg.getBlock4());
    }

    public static List<Field95P> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field95P.getAll(msg.getBlock4());
    }

    public static List<Field95P> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("95P");
        if (arr != null && arr.length > 0) {
            ArrayList<Field95P> result = new ArrayList<Field95P>(arr.length);
            for (Tag f : arr) {
                result.add(new Field95P(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 95P");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("BIC");
        return result;
    }
}

