/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.Validate;

public class AckSystemMessage
extends AbstractMT {
    public AckSystemMessage(SwiftMessage aMessage) {
        super(aMessage);
        Validate.isTrue((boolean)aMessage.isServiceMessage21());
    }

    public static AbstractMT newInstance(SwiftMessage swiftMessage) {
        return new AckSystemMessage(swiftMessage);
    }

    public static AckSystemMessage parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new AckSystemMessage(m.message());
    }

    public AckSystemMessage(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static AckSystemMessage parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new AckSystemMessage(stream);
    }

    public AckSystemMessage(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static AckSystemMessage parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new AckSystemMessage(file);
    }

    public AckSystemMessage(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = AckSystemMessage.read(fin)) != null) {
            this.m = parsed;
            Validate.isTrue((boolean)parsed.isServiceMessage21());
        }
    }

    public static AckSystemMessage parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new AckSystemMessage(fin);
    }

    @Override
    public String getMessageType() {
        return null;
    }

    public final boolean isAck() {
        return this.m.isAck();
    }

    public final boolean isNack() {
        return this.m.isNack();
    }

    public String getErrorCode() {
        Tag t = this.m.getBlock4().getTagByName("405");
        if (t == null) {
            return null;
        }
        return t.asField().getComponent(1);
    }

    public String getErrorLine() {
        Tag t = this.m.getBlock4().getTagByName("405");
        if (t == null) {
            return null;
        }
        return t.asField().getComponent(2);
    }
}

