/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt4xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field33D;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52B;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field71B;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field77A;
import com.prowidesoftware.swift.model.field.Field77D;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT456
extends AbstractMT
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT456.class.getName());
    public static final String NAME = "456";

    public MT456(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT456(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT456 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT456(m.message());
    }

    public MT456() {
        this("TESTUS00", "TESTUS00");
    }

    public MT456(String sender, String receiver) {
        super(456, sender, receiver);
    }

    @Deprecated
    public MT456(int messageType, String sender, String receiver) {
        super(456, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT456(int, String, String)", "Use the constructor MT456(sender, receiver) instead.");
    }

    public MT456(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT456.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT456 object from FIN content with a Service Message. Check if the MT456 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT456 object from FIN content with message type " + param.getType());
        }
    }

    public static MT456 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT456(fin);
    }

    public MT456(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT456 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT456(stream);
    }

    public MT456(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT456 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT456(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT456 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT456 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT456 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field25 getField25() {
        Tag t = this.tag("25");
        if (t != null) {
            return new Field25(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52B getField52B() {
        Tag t = this.tag("52B");
        if (t != null) {
            return new Field52B(t.getValue());
        }
        return null;
    }

    public Field52D getField52D() {
        Tag t = this.tag("52D");
        if (t != null) {
            return new Field52D(t.getValue());
        }
        return null;
    }

    public List<Field20> getField20() {
        ArrayList<Field20> result = new ArrayList<Field20>();
        Tag[] tags = this.tags("20");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field20(tags[i].getValue()));
        }
        return result;
    }

    public List<Field21> getField21() {
        ArrayList<Field21> result = new ArrayList<Field21>();
        Tag[] tags = this.tags("21");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field21(tags[i].getValue()));
        }
        return result;
    }

    public List<Field32A> getField32A() {
        ArrayList<Field32A> result = new ArrayList<Field32A>();
        Tag[] tags = this.tags("32A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field32A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field32B> getField32B() {
        ArrayList<Field32B> result = new ArrayList<Field32B>();
        Tag[] tags = this.tags("32B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field32B(tags[i].getValue()));
        }
        return result;
    }

    public List<Field33D> getField33D() {
        ArrayList<Field33D> result = new ArrayList<Field33D>();
        Tag[] tags = this.tags("33D");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field33D(tags[i].getValue()));
        }
        return result;
    }

    public List<Field71B> getField71B() {
        ArrayList<Field71B> result = new ArrayList<Field71B>();
        Tag[] tags = this.tags("71B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field71B(tags[i].getValue()));
        }
        return result;
    }

    public List<Field77A> getField77A() {
        ArrayList<Field77A> result = new ArrayList<Field77A>();
        Tag[] tags = this.tags("77A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field77A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field77D> getField77D() {
        ArrayList<Field77D> result = new ArrayList<Field77D>();
        Tag[] tags = this.tags("77D");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field77D(tags[i].getValue()));
        }
        return result;
    }

    public List<Field72> getField72() {
        ArrayList<Field72> result = new ArrayList<Field72>();
        Tag[] tags = this.tags("72");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field72(tags[i].getValue()));
        }
        return result;
    }
}

