/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt5xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field34B;
import com.prowidesoftware.swift.model.field.Field35B;
import com.prowidesoftware.swift.model.field.Field35H;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field80C;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT581
extends AbstractMT
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT581.class.getName());
    public static final String NAME = "581";

    public MT581(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT581(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT581 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT581(m.message());
    }

    public MT581() {
        this("TESTUS00", "TESTUS00");
    }

    public MT581(String sender, String receiver) {
        super(581, sender, receiver);
    }

    @Deprecated
    public MT581(int messageType, String sender, String receiver) {
        super(581, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT581(int, String, String)", "Use the constructor MT581(sender, receiver) instead.");
    }

    public MT581(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT581.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT581 object from FIN content with a Service Message. Check if the MT581 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT581 object from FIN content with message type " + param.getType());
        }
    }

    public static MT581 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT581(fin);
    }

    public MT581(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT581 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT581(stream);
    }

    public MT581(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT581 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT581(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT581 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT581 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT581 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field23 getField23() {
        Tag t = this.tag("23");
        if (t != null) {
            return new Field23(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field35H getField35H() {
        Tag t = this.tag("35H");
        if (t != null) {
            return new Field35H(t.getValue());
        }
        return null;
    }

    public Field35B getField35B() {
        Tag t = this.tag("35B");
        if (t != null) {
            return new Field35B(t.getValue());
        }
        return null;
    }

    public Field80C getField80C() {
        Tag t = this.tag("80C");
        if (t != null) {
            return new Field80C(t.getValue());
        }
        return null;
    }

    public Field34B getField34B() {
        Tag t = this.tag("34B");
        if (t != null) {
            return new Field34B(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }
}

