/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt5xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field11S;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field79;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT592
extends AbstractMT
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT592.class.getName());
    public static final String NAME = "592";

    public MT592(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT592(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT592 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT592(m.message());
    }

    public MT592() {
        this("TESTUS00", "TESTUS00");
    }

    public MT592(String sender, String receiver) {
        super(592, sender, receiver);
    }

    @Deprecated
    public MT592(int messageType, String sender, String receiver) {
        super(592, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT592(int, String, String)", "Use the constructor MT592(sender, receiver) instead.");
    }

    public MT592(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT592.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT592 object from FIN content with a Service Message. Check if the MT592 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT592 object from FIN content with message type " + param.getType());
        }
    }

    public static MT592 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT592(fin);
    }

    public MT592(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT592 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT592(stream);
    }

    public MT592(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT592 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT592(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT592 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT592 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT592 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field11S getField11S() {
        Tag t = this.tag("11S");
        if (t != null) {
            return new Field11S(t.getValue());
        }
        return null;
    }

    public Field79 getField79() {
        Tag t = this.tag("79");
        if (t != null) {
            return new Field79(t.getValue());
        }
        return null;
    }
}

